<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class TeamsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Generate dummy data for teams
        $teams = [
            [
                'name' => 'Team A',
                'position' => 'Position A',
                'photo' => 'team_a.jpg',
                'slug' => Str::slug('Team A'),
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Team B',
                'position' => 'Position B',
                'photo' => 'team_b.jpg',
                'slug' => Str::slug('Team B'),
                'status' => 'inactive',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Add more teams as needed
        ];

        // Insert data into teams table
        DB::table('teams')->insert($teams);
    }
}
