<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class StatisticsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $statistics = [
            [
                'title' => 'Monthly Sales',
                'price' => '5000',
                'slug' => Str::slug('Monthly Sales'),
                'status' => 'active'
            ],
            [
                'title' => 'Annual Revenue',
                'price' => '60000',
                'slug' => Str::slug('Annual Revenue'),
                'status' => 'active'
            ],
            [
                'title' => 'Customer Growth',
                'price' => '1500',
                'slug' => Str::slug('Customer Growth'),
                'status' => 'inactive'
            ],
            // Add more statistics entries as needed
        ];

        foreach ($statistics as $stat) {
            DB::table('statistics')->insert([
                'title' => $stat['title'],
                'price' => $stat['price'],
                'slug' => $stat['slug'],
                'status' => $stat['status'],
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
