<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class ServicesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
         // Generate dummy data for services
         $services = [
            [
                'title' => 'Web Development',
                'subtitle' => 'Crafting responsive and scalable web applications.',
                'slug' => Str::slug('Web Development'),
                'description' => 'We specialize in creating modern and responsive web applications using the latest technologies.',
                'photo' => 'web_development.jpg',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Mobile App Development',
                'subtitle' => 'Building innovative mobile applications for iOS and Android.',
                'slug' => Str::slug('Mobile App Development'),
                'description' => 'We develop native and hybrid mobile apps that deliver exceptional user experiences.',
                'photo' => 'mobile_app_development.jpg',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'UI/UX Design',
                'subtitle' => 'Creating intuitive and engaging user interfaces.',
                'slug' => Str::slug('UI/UX Design'),
                'description' => 'Our UI/UX design services focus on creating interfaces that are both functional and aesthetically pleasing.',
                'photo' => 'ui_ux_design.jpg',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Add more services as needed
        ];

        // Insert data into services table
        DB::table('services')->insert($services);
    }
}
