<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class PostsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Let's generate some example posts
        DB::table('posts')->insert([
            [
                'title' => 'First Post',
                'slug' => Str::slug('First Post'),
                'description' => 'This is the first post.',
                'photo' => 'first-post.jpg',
                'tags' => 'first, post',
                'post_tag_id' => 1, // Replace with an existing post_tag_id
                'added_by' => 1, // Replace with an existing user ID
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Second Post',
                'slug' => Str::slug('Second Post'),
                'description' => 'This is the second post.',
                'photo' => 'second-post.jpg',
                'tags' => 'second, post',
                'post_tag_id' => 2, // Replace with an existing post_tag_id
                'added_by' => 2, // Replace with an existing user ID
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Add more posts as needed
        ]);
    }
}
