<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class PostTagsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $postTags = [
            ['title' => 'Technology', 'slug' => Str::slug('Technology')],
            ['title' => 'Health', 'slug' => Str::slug('Health')],
            ['title' => 'Travel', 'slug' => Str::slug('Travel')],
            ['title' => 'Education', 'slug' => Str::slug('Education')],
            ['title' => 'Business', 'slug' => Str::slug('Business')],
        ];

        foreach ($postTags as $tag) {
            DB::table('post_tags')->insert([
                'title' => $tag['title'],
                'slug' => $tag['slug'],
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
