<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class MessagesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Generate dummy data for messages
        $messages = [
            [
                'name' => 'John Doe',
                'subject' => 'Inquiry about services',
                'email' => 'johndoe@example.com',
                'message' => 'I would like to know more about your services.',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Jane Smith',
                'subject' => 'Feedback on website',
                'email' => 'janesmith@example.com',
                'message' => 'Your website is very user-friendly and informative.',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Alice Johnson',
                'subject' => 'Support request',
                'email' => 'alicejohnson@example.com',
                'message' => 'I need help with my account.',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Add more messages as needed
        ];

        // Insert data into messages table
        DB::table('messages')->insert($messages);
    }
}
