<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class FAQSTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $faqs = [
            [
                'title' => 'What is the return policy?',
                'description' => 'You can return any item within 30 days of purchase.',
                'slug' => Str::slug('What is the return policy?'),
                'status' => 'active'
            ],
            [
                'title' => 'How do I track my order?',
                'description' => 'You can track your order using the tracking link sent to your email.',
                'slug' => Str::slug('How do I track my order?'),
                'status' => 'active'
            ],
            [
                'title' => 'What payment methods are accepted?',
                'description' => 'We accept Visa, MasterCard, PayPal, and Apple Pay.',
                'slug' => Str::slug('What payment methods are accepted?'),
                'status' => 'inactive'
            ],
            // Add more FAQ entries as needed
        ];

        foreach ($faqs as $faq) {
            DB::table('f_a_q_s')->insert([
                'title' => $faq['title'],
                'description' => $faq['description'],
                'slug' => $faq['slug'],
                'status' => $faq['status'],
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
