<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class DocumentsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Define your seed data
        $documents = [
            [
                'title' => 'Document 1',
                'slug' => Str::slug('Document 1', '-'),
                'photo' => 'document1.jpg',
                'file' => 'file1.pdf',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Document 2',
                'slug' => Str::slug('Document 2', '-'),
                'photo' => 'document2.jpg',
                'file' => 'file2.pdf',
                'status' => 'inactive',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Document 3',
                'slug' => Str::slug('Document 3', '-'),
                'photo' => 'document3.jpg',
                'file' => 'file3.pdf',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ];

        // Insert the data
        DB::table('documents')->insert($documents);
    }
}
