<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class DestinationsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('destinations')->insert([
            [
                'title' => 'Beautiful Beach Resort',
                'slug' => Str::slug('Beautiful Beach Resort'),
                'summary' => 'A stunning beach resort with white sandy.',
                'description' => 'A stunning beach resort with white sandy beaches and crystal clear water.',
                'country' => 'Uganda',
                'location' => 'Toronto District',
                'language' => 'English',
                'area' => '150',
                'visa' => 'yes',
                'photo' => 'public/images/default_beach.jpg',
                'images' => 'public/multiple_images/image1.jpg,public/multiple_images/image2.jpg',
                'tags' => 'Beach,Resort,Vacation',
                'destination_tag_id' => 1, // Ensure this ID exists in the destination_tags table
                'added_by' => 1, // Ensure this ID exists in the users table
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Mountain Adventure',
                'slug' => Str::slug('Mountain Adventure'),
                'summary' => 'A stunning beach resort with white sandy.',
                'description' => 'A stunning beach resort with white sandy beaches and crystal clear water.',
                'country' => 'Tanzania',
                'location' => 'Mwanza District',
                'language' => 'English',
                'area' => '300',
                'visa' => 'no',
                'photo' => 'public/images/default_mountain.jpg',
                'images' => 'public/multiple_images/image3.jpg,public/multiple_images/image4.jpg',
                'tags' => 'Mountain,Adventure,Hiking',
                'destination_tag_id' => 2, // Ensure this ID exists in the destination_tags table
                'added_by' => 2, // Ensure this ID exists in the users table
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Add more destinations as needed
        ]);
    }
}
