<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class DestinationTagsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $tags = [
            ['title' => 'Beach', 'slug' => Str::slug('Beach')],
            ['title' => 'Mountain', 'slug' => Str::slug('Mountain')],
            ['title' => 'City', 'slug' => Str::slug('City')],
            ['title' => 'Adventure', 'slug' => Str::slug('Adventure')],
            ['title' => 'Relaxation', 'slug' => Str::slug('Relaxation')],
        ];

        foreach ($tags as $tag) {
            DB::table('destination_tags')->insert([
                'title' => $tag['title'],
                'slug' => $tag['slug'],
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
