<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('categories')->insert([
            [
                'title' => 'Adventure',
                'description' => 'Tours that offer thrilling experiences and adventurous activities.',
                'slug' => Str::slug('Adventure'),
                'icon' => 'fa fa-mountain',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Cultural',
                'description' => 'Explore the rich cultural heritage and traditions of various destinations.',
                'slug' => Str::slug('Cultural'),
                'icon' => 'fa fa-landmark',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Beach',
                'description' => 'Relax and unwind on some of the world’s most beautiful beaches.',
                'slug' => Str::slug('Beach'),
                'icon' => 'fa fa-umbrella-beach',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Wildlife',
                'description' => 'Experience the wonders of wildlife and nature.',
                'slug' => Str::slug('Wildlife'),
                'icon' => 'fa fa-paw',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'City Tours',
                'description' => 'Discover the famous landmarks and attractions of bustling cities.',
                'slug' => Str::slug('City Tours'),
                'icon' => 'fa fa-city',
                'status' => 'inactive',
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ]);
    }
}
