<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddAvailiabilityToToursTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('tours', function (Blueprint $table) {
            $table->enum('availability_type', ['year_round', 'seasonal', 'custom'])->default('year_round')->after('status');
            $table->json('unavailable_periods')->nullable()->after('availability_type');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('tours', function (Blueprint $table) {
            $table->dropColumn('availability_type');
            $table->dropColumn('unavailable_periods');
        });
    }
}
