<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class SeedLocationCategoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Insert default location categories
        DB::table('location_categories')->insert([
            [
                'title' => 'Tanzania Mainland',
                'slug' => 'tanzania-mainland',
                'description' => 'Tours and destinations in mainland Tanzania including Serengeti, Kilimanjaro, and other mainland attractions.',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Zanzibar',
                'slug' => 'zanzibar',
                'description' => 'Tours and destinations in Zanzibar archipelago including Stone Town, beaches, and spice tours.',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Kenya',
                'slug' => 'kenya',
                'description' => 'Tours and destinations in Kenya including Masai Mara, Nairobi, and coastal areas.',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Uganda',
                'slug' => 'uganda',
                'description' => 'Tours and destinations in Uganda including gorilla trekking and national parks.',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ]
        ]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::table('location_categories')->whereIn('slug', [
            'tanzania-mainland', 'zanzibar', 'kenya', 'uganda'
        ])->delete();
    }
}
