<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnToDestinationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('destinations', function (Blueprint $table) {
            // Add new location_category_id column
            $table->unsignedBigInteger('location_category_id')->nullable()->after('destination_tag_id');
            
            // Add foreign key constraint
            $table->foreign('location_category_id')->references('id')->on('location_categories')->onDelete('SET NULL');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('destinations', function (Blueprint $table) {
            // Drop foreign key and column
            $table->dropForeign(['location_category_id']);
            $table->dropColumn('location_category_id');
        });
    }
}
