<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnToToursTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('tours', function (Blueprint $table) {
            // Add new location_category_id column
            $table->unsignedBigInteger('location_category_id')->nullable()->after('exclude_tour_id');
            
            // Add foreign key constraint
            $table->foreign('location_category_id')->references('id')->on('location_categories')->onDelete('SET NULL');
        });

        // Remove the old enum categories column in a separate operation
        Schema::table('tours', function (Blueprint $table) {
            $table->dropColumn('categories');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('tours', function (Blueprint $table) {
            // Drop foreign key and column
            $table->dropForeign(['location_category_id']);
            $table->dropColumn('location_category_id');
            
            // Add back the old enum column
            $table->enum('categories', ['tanzania-mainland', 'zanzibar'])->default('zanzibar')->after('discount');
        });
    }
}
