<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateToursTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tours', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('slug')->unique();
            $table->longText('description')->nullable();
            $table->string('photo')->nullable();
            $table->string('tags')->nullable();
            $table->string('includes')->nullable();
            $table->string('excludes')->nullable();
            $table->unsignedBigInteger('tour_tag_id')->nullable();
            $table->unsignedBigInteger('include_tour_id')->nullable();
            $table->unsignedBigInteger('exclude_tour_id')->nullable();
            $table->unsignedBigInteger('added_by')->nullable();
            $table->string('location');
            $table->longText('map')->nullable();
            $table->string('age');
            $table->integer('number_of_days');
            $table->string('images', 1000)->nullable();
            $table->decimal('price', 10, 2);
            $table->decimal('price_per_child', 10, 2);
            $table->decimal('discount', 10, 2)->default(0.00); // New field
            $table->enum('categories', ['tanzania-mainland', 'zanzibar'])->default('zanzibar');
            $table->enum('status', ['active', 'inactive'])->default('active');
            $table->longText('itinerary_titles')->nullable(); // Added field
            $table->longText('itinerary_descriptions')->nullable(); // Added field
            $table->foreign('tour_tag_id')->references('id')->on('tour_tags')->onDelete('SET NULL');
            $table->foreign('include_tour_id')->references('id')->on('include_tours')->onDelete('SET NULL');
            $table->foreign('exclude_tour_id')->references('id')->on('exclude_tours')->onDelete('SET NULL');
            $table->foreign('added_by')->references('id')->on('users')->onDelete('SET NULL');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tours');
    }
}
