<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDestinationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('destinations', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('slug')->unique();
            $table->longText('summary')->nullable();
            $table->longText('description')->nullable();
            $table->string('country');
            $table->string('location');
            $table->string('language');
            $table->string('area');
            $table->enum('visa',['yes','no'])->default('yes');
            $table->string('photo')->nullable();
            $table->string('images', 1000)->nullable();
            $table->string('tags')->nullable();
            $table->unsignedBigInteger('destination_tag_id')->nullable();
            $table->unsignedBigInteger('added_by')->nullable();
            $table->enum('status',['active','inactive'])->default('active');
            $table->foreign('destination_tag_id')->references('id')->on('destination_tags')->onDelete('SET NULL');
            $table->foreign('added_by')->references('id')->on('users')->onDelete('SET NULL');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('destinations');
    }
}
