<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Post extends Model
{
    protected $fillable=['title','tags','slug','description','photo','summary','post_tag_id','added_by','status'];

    public function tag_info(){
        return $this->hasOne('App\Models\PostTag','id','post_tag_id');
    }
    // In your Post model
    public function allComments()
    {
        return $this->hasMany(PostComment::class);
    }
    public function author_info(){
        return $this->hasOne('App\User','id','added_by');
    }
    public static function getAllPost(){
        return Post::with(['author_info'])->orderBy('id','ASC')->paginate(10);
    }

    public static function getPostBySlug($slug){
        return Post::with(['tag_info','author_info'])->where('slug',$slug)->where('status','active')->first();
    }

    public static function getBlogByTag($slug){
        $postTag=PostTag::where('slug',$slug)->first();
        return Post::where("post_tag_id", $postTag->id)->paginate(100);
    }

    public static function countActivePost(){
        $data=Post::where('status','active')->count();
        if($data){
            return $data;
        }
        return 0;
    }
    public static function uniqueTags()
    {
        // Get all comma-separated tags from the table
        $allTags = Post::whereNotNull('tags')
            ->where('tags', '!=', '')
            ->pluck('tags')
            ->toArray();
        
        // Process to get unique tags
        $uniqueTags = collect($allTags)
            ->flatMap(function ($tags) {
                return array_map('trim', explode(',', $tags));
            })
            ->unique()
            ->sort()
            ->values()
            ->toArray();
            return $uniqueTags;
    }
}
