<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PageBanner extends Model
{
    protected $fillable = [
        'page_slug',
        'banner_image',
        'status'
    ];

    protected $casts = [
        'status' => 'boolean',
    ];

    // Get banner image URL
    public function getBannerUrlAttribute()
    {
        if ($this->banner_image) {
            return asset('storage/' . $this->banner_image);
        }
        return null;
    }
}
