<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    protected $fillable = [
        'first_name','last_name', 'email', 'phone', 'country', 'language', 'number_adult', 
        'number_child', 'age_child', 'date_arrival', 'total_stay', 'experience', 'accomodation',
        'budget', 'like_most', 'dislike_most', 'brief_descript', 'tour_id'
    ];

    public function tour(){
        return $this->hasOne('App\Models\Tour','id','tour_id');
    }

    public static function getAllOrder($id){
        return Order::with('tour')->find($id);
    }

    public static function countActiveOrder()
    {
        $data = Order::count();
        return $data ? $data : 0;
    }
}
