<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class LocationCategory extends Model
{
    use HasFactory;

    protected $fillable = [
        'title', 'slug', 'description', 'photo', 'banner', 'status'
    ];

    public static function boot()
    {
        parent::boot();
        
        static::creating(function ($model) {
            if (empty($model->slug)) {
                $model->slug = Str::slug($model->title);
            }
        });

        static::updating(function ($model) {
            if ($model->isDirty('title')) {
                $model->slug = Str::slug($model->title);
            }
        });
    }

    public static function getAllLocationCategories()
    {
        return LocationCategory::orderBy('id', 'ASC')->paginate(10);
    }

    public static function getActiveLocationCategories()
    {
        return LocationCategory::where('status', 'active')->orderBy('title', 'ASC')->get();
    }

    public function tours()
    {
        return $this->hasMany(Tour::class, 'location_category_id');
    }

    public function destinations()
    {
        return $this->hasMany(Destination::class, 'location_category_id');
    }

    public static function countActiveLocationCategories()
    {
        $data = LocationCategory::where('status', 'active')->count();
        return $data ? $data : 0;
    }
}
