<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Destination extends Model
{
    protected $fillable=[
        'title','tags','slug','description', 'summary', 'pros', 'cons', 'country' ,'location', 'language', 'area', 'visa', 'images', 
         'photo', 'destination_tag_id', 'location_category_id','added_by','status'
        ];

    protected $casts = [
        'pros' => 'array',
        'cons' => 'array',
    ];

    public function tag_info(){
        return $this->hasOne('App\Models\DestinationTag','id','destination_tag_id');
    }

    public function author_info(){
        return $this->hasOne('App\User','id','added_by');
    }

    public function location_category(){
        return $this->belongsTo('App\Models\LocationCategory','location_category_id','id');
    }

    public static function getDestinationBySlug($slug){
        return Destination::with(['tag_info','author_info', 'location_category'])->where('slug',$slug)->first();
    }

    public static function getDestinationByTag($slug){
        // dd($slug);
        return Destination::where('tags',$slug)->paginate(8);
    }

    public static function getAllDestination(){
        return Destination::with(['author_info'])->orderBy('id','ASC')->paginate(10);
    }

    public static function countActiveDestination(){
        $data=Destination::where('status','active')->count();
        if($data){
            return $data;
        }
        return 0;
    }

    public static function getDestinationByCategory($slug){

        return Destination::with(['tag_info','author_info', 'location_category'])->where('location_category_id',$slug)->orderBy('id','DESC')->get();
    }
}
