<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ContactFormMail extends Mailable
{
    use Queueable, SerializesModels;

    public $emailData;
    public $recent_posts;

    public function __construct($emailData,$recent_posts)
    {
        $this->emailData = $emailData;
        $this->recent_posts=$recent_posts;
    }

    public function build()
    {
        return $this->subject('New Contact Form Submission')
                    ->view('emails.contact-form')
                    ->with('emailData', $this->emailData)
                    ->with('recent_posts',$this->recent_posts);
    }
}
