<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\TourTag;
use Illuminate\Support\Str;

class TourTagController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $tourTag=TourTag::orderBy('id','ASC')->paginate(57);
        return view('backend.tourtag.index')->with('tourTags',$tourTag);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.tourtag.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'title'=>'string|required',
            'photo'=>'nullable|image|mimes:jpg,png,jpeg,gif,svg',
            'banner'=>'nullable|image|mimes:jpg,png,jpeg,gif,svg',
            'status'=>'required|in:active,inactive'
        ]);
        $data=$request->all();
        $slug=Str::slug($request->title);
        $count=TourTag::where('slug',$slug)->count();
        if($count>0){
            $slug=$slug.'-'.date('ymdis').'-'.rand(0,999);
        }
        $data['slug']=$slug;
        
        // Handle photo upload
        if($request->hasFile('photo')){
            $path = $request->file('photo')->store('public/images');
            $data['photo'] = $path;
        }
        
        // Handle banner upload
        if($request->hasFile('banner')){
            $path = $request->file('banner')->store('public/images');
            $data['banner'] = $path;
        }
        
        $status=TourTag::create($data);
        if($status){
            request()->session()->flash('success','Tour Tag Successfully added');
        }
        else{
            request()->session()->flash('error','Please try again!!');
        }
        return redirect()->route('tour-tag.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $tourTag=TourTag::findOrFail($id);
        return view('backend.tourtag.edit')->with('tourTag',$tourTag);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $tourTag=TourTag::findOrFail($id);
         // return $request->all();
         $this->validate($request,[
            'title'=>'string|required',
            'photo'=>'nullable|image|mimes:jpg,png,jpeg,gif,svg',
            'banner'=>'nullable|image|mimes:jpg,png,jpeg,gif,svg',
            'status'=>'required|in:active,inactive'
        ]);
        $data=$request->all();
        
        // Handle photo update
        if($request->hasFile('photo')){
            $path = $request->file('photo')->store('public/images');
            $data['photo'] = $path;
        } else {
            unset($data['photo']); // Remove photo key if no new photo is uploaded
        }
        
        // Handle banner update
        if($request->hasFile('banner')){
            $path = $request->file('banner')->store('public/images');
            $data['banner'] = $path;
        } else {
            unset($data['banner']); // Remove banner key if no new banner is uploaded
        }
        
        $status=$tourTag->fill($data)->save();
        if($status){
            request()->session()->flash('success','Tour Tag Successfully updated');
        }
        else{
            request()->session()->flash('error','Please try again!!');
        }
        return redirect()->route('tour-tag.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $tourTag=TourTag::findOrFail($id);
       
        $status=$tourTag->delete();
        
        if($status){
            request()->session()->flash('success','Tour Tag successfully deleted');
        }
        else{
            request()->session()->flash('error','Error while deleting tour tag');
        }
        return redirect()->route('tour-tag.index');
    }
}
