<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Models\Post;
use App\Models\PostTag;
use App\User;

class PostController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $posts = Post::orderBy('id', 'ASC')->paginate(57);
        // return $posts;
        return view('backend.post.index')->with('posts',$posts);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $tags=PostTag::get();
        $users=User::get();
        return view('backend.post.create')->with('users',$users)->with('tags',$tags);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // return $request->all();
        $this->validate($request,[
            'title'=>'string|required',
            'description'=>'string|nullable',
            // 'quote'=>'string|required',
            'summary'=>'string|nullable',
            'photo'=>'required|image|mimes:jpg,png,jpeg,gif,svg|max:2048',
            'tags'=>'nullable',
            'added_by'=>'nullable',
            'status'=>'required|in:active,inactive'
        ]);

        $data=$request->all();

        $slug=Str::slug($request->title);
        $count=Post::where('slug',$slug)->count();
        if($count>0){
            $slug=$slug.'-'.date('ymdis').'-'.rand(0,999);
        }
        $data['slug']=$slug;
        $data['title'] = $request->get('title');
        $data['description'] = $request->get('description');
        $data['added_by'] = auth()->id();
        // $data['quote'] = $request->get('quote');
        $data['summary'] = $request->get('summary');
        $data['status'] = $request->get('status');

        $tags=$request->input('tags');
        if($tags){
            $tag_id = PostTag::where('title',$tags)->first();
            if($tag_id) {
                $data['post_tag_id'] = $tag_id->id;
            }
            $data['tags'] = $tags;
        }
        else{
            $data['post_tag_id'] = '';
            $data['tags']='';
        }
        // return $data;
        $path = $request->file('photo')->store('public/images');
        $data['photo'] = $path;
        $status=Post::create($data);
        if($status){
            request()->session()->flash('success','Post Successfully added');
        }
        else{
            request()->session()->flash('error','Please try again!!');
        }
        return redirect()->route('post.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $post=Post::findOrFail($id);
        $tags=PostTag::get();
        $users=User::get();
        return view('backend.post.edit')->with('users',$users)->with('tags',$tags)->with('post',$post);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $post = Post::findOrFail($id);

        $this->validate($request, [
            'title' => 'string|required',
            'description' => 'string|nullable',
            // 'quote'=>'string|required',
            'summary'=>'string|nullable',
            'photo' => 'nullable|image|mimes:jpg,png,jpeg,gif,svg|max:2048',
            'tags' => 'nullable',
            'added_by' => 'nullable',
            'status' => 'required|in:active,inactive'
        ]);

        $data = $request->all();
        $data['title'] = $request->get('title');
        $data['description'] = $request->get('description');
        $data['added_by'] = $request->get('added_by');
        // $data['quote'] = $request->get('quote');
        $data['summary'] = $request->get('summary');
        $data['status'] = $request->get('status');

        // Handle tags update
        $tags = $request->input('tags');
        if ($tags) {
            $tag_id = PostTag::where('title',$tags)->first();
            if($tag_id) {
                $data['post_tag_id'] = $tag_id->id;
            }
            $data['tags'] = $tags;
        } else {
            $data['post_tag_id'] = '';
            $data['tags'] = '';
        } 

        // Handle photo update only if a new one is provided
        if ($request->hasFile('photo')) {
            $path = $request->file('photo')->store('public/images');
            $data['photo'] = $path;
        } else {
            unset($data['photo']); // Remove the 'photo' key if it is not provided in the request
        }

        $status = $post->fill($data)->save();

        if ($status) {
            request()->session()->flash('success', 'Post successfully updated');
        } else {
            request()->session()->flash('error', 'Please try again!!');
        }

        return redirect()->route('post.index');
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $post=Post::findOrFail($id);
       
        $status=$post->delete();
        
        if($status){
            request()->session()->flash('success','Post successfully deleted');
        }
        else{
            request()->session()->flash('error','Error while deleting post ');
        }
        return redirect()->route('post.index');
    }
}
