<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\IncludeTour;
use Illuminate\Support\Str;

class IncludeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $includeTours=IncludeTour::orderBy('id','ASC')->paginate(57);
        return view('backend.includetour.index')->with('includeTours',$includeTours);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.includetour.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'title'=>'string|required',
            'status'=>'required|in:active,inactive'
        ]);
        $data=$request->all();
        $slug=Str::slug($request->title);
        $count=IncludeTour::where('slug',$slug)->count();
        if($count>0){
            $slug=$slug.'-'.date('ymdis').'-'.rand(0,999);
        }
        $data['slug']=$slug;
        $status=IncludeTour::create($data);
        if($status){
            request()->session()->flash('success','Include Tour Successfully added');
        }
        else{
            request()->session()->flash('error','Please try again!!');
        }
        return redirect()->route('include-tour.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $includeTour=IncludeTour::findOrFail($id);
        return view('backend.includetour.edit')->with('includeTour',$includeTour);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $includeTour=IncludeTour::findOrFail($id);
         // return $request->all();
         $this->validate($request,[
            'title'=>'string|required',
            'status'=>'required|in:active,inactive'
        ]);
        $data=$request->all();
        $status=$includeTour->fill($data)->save();
        if($status){
            request()->session()->flash('success','Include Tour Successfully updated');
        }
        else{
            request()->session()->flash('error','Please try again!!');
        }
        return redirect()->route('include-tour.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $includeTour=IncludeTour::findOrFail($id);
       
        $status=$includeTour->delete();
        
        if($status){
            request()->session()->flash('success','Include Tour successfully deleted');
        }
        else{
            request()->session()->flash('error','Error while deleting include tour');
        }
        return redirect()->route('include-tour.index');
    }
}
