<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\FAQ;
use Illuminate\Support\Str;

class FAQController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $faq=FAQ::orderBy('id','ASC')->paginate(57);
        return view('backend.faq.index')->with('faqs',$faq);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.faq.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // return $request->all();
        $this->validate($request,[
            'title'=>'string|required|max:100',
            'description'=>'string|nullable',
            'status'=>'required|in:active,inactive',
        ]);
        $data=$request->all();
        $slug=Str::slug($request->title);
        $count=FAQ::where('slug',$slug)->count();
        if($count>0){
            $slug=$slug.'-'.date('ymdis').'-'.rand(0,999);
        }
        $data['slug']=$slug;
        $data['title'] = $request->get('title');
        $data['description'] = $request->get('description');
        $data['status'] = $request->get('status');
        $status=FAQ::create($data);
        if($status){
            request()->session()->flash('success','FAQ successfully added');
        }
        else{
            request()->session()->flash('error','Error occurred while adding faq');
        }
        return redirect()->route('faq.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $faq=FAQ::findOrFail($id);
        return view('backend.faq.edit')->with('faq',$faq);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $faq=FAQ::findOrFail($id);
        $this->validate($request,[
            'title'=>'string|required|max:100',
            'description'=>'string|nullable',
            'status'=>'required|in:active,inactive',
        ]);
        $data=$request->all();

        $data['title'] = $request->get('title');
        $data['description'] = $request->get('description');
        $data['status'] = $request->get('status');

        $status=$faq->fill($data)->save();
        if($status){
            request()->session()->flash('success','FAQ successfully updated');
        }
        else{
            request()->session()->flash('error','Error occurred while updating faq');
        }
        return redirect()->route('faq.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $faq=FAQ::findOrFail($id);
        $status=$faq->delete();
        if($status){
            request()->session()->flash('success','FAQ successfully deleted');
        }
        else{
            request()->session()->flash('error','Error occurred while deleting faq');
        }
        return redirect()->route('faq.index');
    }
}
