<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ExcludeTour;
use Illuminate\Support\Str;

class ExcludeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $excludeTours=ExcludeTour::orderBy('id','ASC')->paginate(57);
        return view('backend.excludetour.index')->with('excludeTours',$excludeTours);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.excludetour.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'title'=>'string|required',
            'status'=>'required|in:active,inactive'
        ]);
        $data=$request->all();
        $slug=Str::slug($request->title);
        $count=ExcludeTour::where('slug',$slug)->count();
        if($count>0){
            $slug=$slug.'-'.date('ymdis').'-'.rand(0,999);
        }
        $data['slug']=$slug;
        $status=ExcludeTour::create($data);
        if($status){
            request()->session()->flash('success','Exclude Tour Successfully added');
        }
        else{
            request()->session()->flash('error','Please try again!!');
        }
        return redirect()->route('exclude-tour.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $excludeTour=ExcludeTour::findOrFail($id);
        return view('backend.excludetour.edit')->with('excludeTour',$excludeTour);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $excludeTour=ExcludeTour::findOrFail($id);
         // return $request->all();
         $this->validate($request,[
            'title'=>'string|required',
            'status'=>'required|in:active,inactive'
        ]);
        $data=$request->all();
        $status=$excludeTour->fill($data)->save();
        if($status){
            request()->session()->flash('success','Exclude Tour Successfully updated');
        }
        else{
            request()->session()->flash('error','Please try again!!');
        }
        return redirect()->route('exclude-tour.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $excludeTour=ExcludeTour::findOrFail($id);
       
        $status=$excludeTour->delete();
        
        if($status){
            request()->session()->flash('success','Exclude Tour successfully deleted');
        }
        else{
            request()->session()->flash('error','Error while deleting exclude tour');
        }
        return redirect()->route('exclude-tour.index');
    }
}
