<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\DestinationTag;
use Illuminate\Support\Str;
class DestinationTagController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $destinationTag=DestinationTag::orderBy('id','ASC')->paginate(57);
        return view('backend.destinationtag.index')->with('destinationTags',$destinationTag);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.destinationtag.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'title'=>'string|required',
            'status'=>'required|in:active,inactive'
        ]);
        $data=$request->all();
        $slug=Str::slug($request->title);
        $count=DestinationTag::where('slug',$slug)->count();
        if($count>0){
            $slug=$slug.'-'.date('ymdis').'-'.rand(0,999);
        }
        $data['slug']=$slug;
        $status=DestinationTag::create($data);
        if($status){
            request()->session()->flash('success','Destination Tag Successfully added');
        }
        else{
            request()->session()->flash('error','Please try again!!');
        }
        return redirect()->route('destination-tag.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $destinationTag=DestinationTag::findOrFail($id);
        return view('backend.destinationtag.edit')->with('destinationTag',$destinationTag);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $destinationTag=DestinationTag::findOrFail($id);
         // return $request->all();
         $this->validate($request,[
            'title'=>'string|required',
            'status'=>'required|in:active,inactive'
        ]);
        $data=$request->all();
        $status=$destinationTag->fill($data)->save();
        if($status){
            request()->session()->flash('success','Destination Tag Successfully updated');
        }
        else{
            request()->session()->flash('error','Please try again!!');
        }
        return redirect()->route('destination-tag.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $destinationTag=DestinationTag::findOrFail($id);
       
        $status=$destinationTag->delete();
        
        if($status){
            request()->session()->flash('success','Destination Tag successfully deleted');
        }
        else{
            request()->session()->flash('error','Error while deleting destination tag');
        }
        return redirect()->route('destination-tag.index');
    }
}
