<?php
include 'includes/conn.php';
if (!isset($_SESSION)) {
  session_start();
}
$allowed_levels = array(1,2,3,8,10);
if ((!isset($_SESSION['schoolsyslevel'])) || !in_array((int)$_SESSION['schoolsyslevel'], $allowed_levels)){
  header('Location: login.php');
  exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>Students With Balance</title>
<link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />

  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
<section>
   <?php include 'includes/header.php'; ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
        
    <div class="col-lg-12">
                      <section class="panel">
                    <header class="panel-heading">
                      Students With Fees Balance
                    </header>
                          <div class="panel-body">
                                              <table  class="display table  table-striped" id="dynamic-table">
        <thead>
        <tr>
             <th>Student No</th>
                                            <th>Full Names</th>
                                            <th>Class</th>
                                                             <th>Gender</th>    
                                                                   <th>Action</th>
                  </tr>
        </thead>
        <tbody>
    
          <?php 
                        $students = mysqli_query($con, "SELECT * FROM students WHERE status=1");
                        if ($students) {
                            while ($row = mysqli_fetch_assoc($students)) {
                                $regnumber = $row['regnumber'];
                                $student_id = (int) $row['student_id'];
                                $fullname = $row['fullname'];
                                $gender = $row['gender'];
                                $joiningyear = $row['joiningyear'];
                                $joiningterm = $row['joiningterm'];
                                $class_id = (int) $row['class_id'];
                                $stream_id = (int) $row['stream_id'];
                                $status = $row['status'];
                                $ext = $row['ext'];
                                $stream = '';
                                $getstream = mysqli_query($con, "SELECT * FROM streams WHERE stream_id={$stream_id}");
                                if ($getstream) {
                                    $roww = mysqli_fetch_assoc($getstream);
                                    if ($roww) $stream = $roww['stream'];
                                }
                                          		
                 $checkpayments = mysqli_query($con, "SELECT * FROM feespayments WHERE student_id={$student_id} AND status=1");
                 if(!$checkpayments || mysqli_num_rows($checkpayments) < 1){ 
                                   ?>
                     <tr class="gradeA">
                                                               <td>
                                 <?php echo htmlspecialchars($regnumber); ?>
                                                       </td>
                      <td><?php echo htmlspecialchars($fullname); ?></td>
                                            <td><?php 
                      $class = '';
                      $getclass = mysqli_query($con, "SELECT * FROM classes WHERE class_id={$class_id}");
                      if ($getclass) {
                        $row2 = mysqli_fetch_assoc($getclass);
                        if ($row2) $class = $row2['class'];
                      }
                       echo htmlspecialchars($class . ' ' . $stream);
                                            ?></td>
                 <td><?php echo htmlspecialchars($gender); ?></td>
                                   <td><a href="accountstudent?id=<?php echo $student_id; ?>" class="btn btn-success btn-xs"><i class="fa fa-user"></i> Details</a>
                                                                                        
                                            </td>
                       
                                        </tr>
           <?php            }else{                              
//                                        $countpayments=0;
                  $countpayments = mysqli_query($con, "SELECT * FROM feespayments WHERE student_id={$student_id} AND status=1 GROUP BY term_id");          
                    $getterms = mysqli_query($con, "SELECT * FROM financialterms WHERE year>='{$joiningyear}' AND term>='{$joiningterm}'");   
                   if((!$countpayments?0:mysqli_num_rows($countpayments)) < (!$getterms?0:mysqli_num_rows($getterms))){
                                         ?>
                                       <tr class="gradeA">
                                                               <td>
                                 <?php echo htmlspecialchars($regnumber); ?>
                                                       </td>
                      <td><?php echo htmlspecialchars($fullname); ?></td>
                                            <td><?php 
                      $class = '';
                      $getclass = mysqli_query($con, "SELECT * FROM classes WHERE class_id={$class_id}");
                      if ($getclass) {
                        $row2 = mysqli_fetch_assoc($getclass);
                        if ($row2) $class = $row2['class'];
                      }
                       echo htmlspecialchars($class . ' ' . $stream);
                                            ?></td>
                 <td><?php echo htmlspecialchars($gender); ?></td>
                <td><a href="accountstudent?id=<?php echo $student_id; ?>" class="btn btn-success btn-xs"><i class="fa fa-user"></i> Details</a>
                                                                                        
                                            </td>
                       
                                        </tr>
                 <?php      }else{
                     $totalpaid = 0;
                     $totalexpected = 0;
                     if ($getterms) {
                       while ($row1 = mysqli_fetch_assoc($getterms)) {
                         $financialterm_id = (int) $row1['financialterm_id'];
                         $term = $row1['term'];
                         $year = $row1['year'];
                         $countpayments = mysqli_query($con, "SELECT SUM(amount) as termpayment, class_id FROM feespayments WHERE student_id={$student_id} AND status=1 AND term_id={$financialterm_id}");
                         $row2 = $countpayments ? mysqli_fetch_assoc($countpayments) : null;
                         $termpayment = $row2['termpayment'] ?? 0;
                         $paid_class_id = isset($row2['class_id']) ? (int)$row2['class_id'] : $class_id;
                         $fees = mysqli_query($con, "SELECT * FROM schoolfees WHERE class_id={$paid_class_id} AND year='{$year}'");
                         $row3 = $fees ? mysqli_fetch_assoc($fees) : null;
                         $feesamount = $row3['amount'] ?? 0;
                         $totalpaid += $termpayment;
                         $totalexpected += $feesamount;
                       }
                     }
                    $balance = $totalexpected - $totalpaid;
                    if ($balance > 0) {
                                          ?>
                                           <tr class="gradeA">
                                                               <td>
                                 <?php echo htmlspecialchars($regnumber); ?>
                                                       </td>
                      <td><?php echo htmlspecialchars($fullname); ?></td>
                      <td><?php 
                      $class = '';
                      $getclass = mysqli_query($con, "SELECT * FROM classes WHERE class_id={$class_id}");
                      if ($getclass) {
                        $row2 = mysqli_fetch_assoc($getclass);
                        if ($row2) $class = $row2['class'];
                      }
                       echo htmlspecialchars($class . ' ' . $stream);
                      ?></td>
                 <td><?php echo htmlspecialchars($gender); ?></td>
                 <td><a href="accountstudent?id=<?php echo $student_id; ?>" class="btn btn-success btn-xs"><i class="fa fa-user"></i> Details</a>
                                                                                        
                                            </td>
                       
                                        </tr>
                 <?php     }
                   }
                 }
                ?>
                                                          								
                                  
      <?php } }
      ?>
        </tbody>
                        </table>
                          </div>
                          </div>
   
        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>

<!-- Placed js at the end of the document so the pages load faster -->
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="js/jquery-migrate-1.2.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/modernizr.min.js"></script>
<script src="js/jquery.nicescroll.js"></script>
<script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
<script src="js/dynamic_table_init.js"></script>
<!--common scripts for all pages-->
<script src="js/scripts.js"></script>

</body>
</html>
