<?php
include 'includes/conn.php';
if (!isset($_SESSION['schoolsyslevel']) || (($_SESSION['schoolsyslevel'] != 1) && ($_SESSION['schoolsyslevel'] != 2))) {
    header('Location: login.php');
    exit;
}
// helper: accept integer timestamp or YYYY-MM-DD date string and return formatted date or empty string
function normalize_date_for_display($val)
{
    if (empty($val) && $val !== '0') {
        return '';
    }
    if (is_numeric($val)) {
        $ts = (int) $val;
        if ($ts <= 0) return '';
        return date('d/M/Y', $ts);
    }
    $d = DateTime::createFromFormat('Y-m-d', $val);
    if (!$d) $d = DateTime::createFromFormat('Y/m/d', $val);
    if (!$d) $d = DateTime::createFromFormat('d-m-Y', $val);
    if (!$d) $d = DateTime::createFromFormat('d/m/Y', $val);
    if (!$d) {
        $ts = strtotime($val);
        if ($ts === false || $ts <= 0) return '';
        return date('d/M/Y', $ts);
    }
    return $d->format('d/M/Y');
}
?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Get Weekly Lesson Plans School Manager</title>
    <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
    <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />

    <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
    <link href="css/chosen/chosen.css" rel="stylesheet">
</head>

<body class="sticky-header">
    <section>
        <?php include 'includes/header.php'; ?>

        <section class="wrapper">
            <!-- page start-->

            <div class="row">

                <div class="col-lg-6">
                    <section class="panel">
                        <header class="panel-heading">
                            Get Weekly Lesson Plans
                        </header>
                        <div class="panel-body">
                            <form action="" method="post">
                                <div class="form-group"><label class="control-label">* Class and Subject</label>
                                    <select data-placeholder="Choose class:subject" required name="class" class="chosen-select" style="width:100%;" tabindex="2">
                                        <option value="">Select Class...</option>
                                        <?php
                                        $getclass = mysqli_query($con, "SELECT * FROM classes WHERE status=1");
                                        if ($getclass) {
                                            while ($row2 = mysqli_fetch_assoc($getclass)) {
                                                $classname = $row2['class'] ?? '';
                                                $class_id = (int) ($row2['class_id'] ?? 0);
                                                $class_subjects = mysqli_query($con, "SELECT * FROM class_subjects WHERE class_id={$class_id}");
                                                if ($class_subjects) {
                                                    while ($row1 = mysqli_fetch_assoc($class_subjects)) {
                                                        $class_id1 = (int) ($row1['class_id'] ?? 0);
                                                        $subject_id1 = (int) ($row1['subject_id'] ?? 0);
                                                        $getclasses = mysqli_query($con, "SELECT * FROM classes WHERE class_id={$class_id1}");
                                                        $row3 = $getclasses ? mysqli_fetch_assoc($getclasses) : null;
                                                        $class1 = $row3['class'] ?? '';
                                                        $getsubjects = mysqli_query($con, "SELECT * FROM subjects WHERE subject_id={$subject_id1}");
                                                        $row4 = $getsubjects ? mysqli_fetch_assoc($getsubjects) : null;
                                                        $subject1 = $row4['subject'] ?? '';
                                                        $label = $class1 . ' : ' . $subject1;
                                        ?>
                                                <option value="<?php echo htmlspecialchars($subject_id1 . '_' . $class_id1); ?>"><?php echo htmlspecialchars($label); ?></option>

                                        <?php   }
                                                }
                                            }
                                        }
                                        ?>
                                    </select>

                                </div>
                                <!-- <div class="form-group">
                                    <label class="control-label">* Subject</label>
                                    <select name="term" class="form-control">
                                        <?php
                                        $terms =  mysqli_query($con, "SELECT  * FROM financialterms WHERE status=1");
                                        while ($row =  mysqli_fetch_array($terms)) {
                                            $financialterm_id = $row['financialterm_id'];
                                            $term = $row['term'];
                                            $year = $row['year'];
                                            $startdate = $row['startdate'];
                                            $enddate = $row['enddate'];
                                            $status = $row['status'];
                                        ?>
                                            <option value="<?php echo $financialterm_id; ?>"><?php echo 'Term ' . $term . ' ' . $year; ?></option>
                                        <?php } ?>
                                    </select>
                                </div> -->
                                <div class="form-group">
                                    <button class="btn btn-sm btn-primary">Proceed</button>
                                </div>
                            </form>

                        </div>

                </div>


            </div>
            <!-- page end-->
             <?php 
             if (!empty($_POST['class'])) { 
                $classRaw = trim($_POST['class']);
                $classParts = explode('_', $classRaw);
                $cl = isset($classParts[1]) ? (int) $classParts[1] : 0;
                $sub = isset($classParts[0]) ? (int) $classParts[0] : 0;
                $subject = '';
                $subjectquery = mysqli_query($con, "SELECT * FROM subjects WHERE subject_id={$sub}");
                if ($subjectquery) {
                    $subjectrow = mysqli_fetch_assoc($subjectquery);
                    $subject = $subjectrow['subject'] ?? '';
                }
                $className = '';
                $classquery = mysqli_query($con, "SELECT * FROM classes WHERE class_id={$cl}");
                if ($classquery) {
                    $classrow = mysqli_fetch_assoc($classquery);
                    $className = $classrow['class'] ?? '';
                }
                
                ?>
            <div class="row">

                <div class="col-lg-12">
                    <?php
                    $class_subjects = mysqli_query($con, "SELECT * FROM class_subjects WHERE class_id={$cl} AND subject_id={$sub}");
                    $row1 = $class_subjects ? mysqli_fetch_assoc($class_subjects) : null;
                    $class_sub_id = $row1['class_sub_id'] ?? 0;
                    ?>
                    <section class="panel">
                        <header class="panel-heading">
                            <?php echo htmlspecialchars($subject . ' : ' . $className); ?> Lesson Weekly Plans
                        </header>
                        <div class="panel-body">
                            <table class="display table  table-striped" id="dynamic-table">
                                <thead>
                                    <tr>
                                        <th>From</th>
                                        <th>To</th>
                                        <th>Term</th>
                                        <th>Year</th>
                                        <th>Periods per Week</th>
                                        <th>Teacher</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $weeklyplans = mysqli_query($con, "SELECT * FROM weeklyplans WHERE class_sub_id={$class_sub_id} AND status=1");
                                    if ($weeklyplans) {
                                        while ($row = mysqli_fetch_assoc($weeklyplans)) {
                                            $weeklyplan_id = (int) ($row['weeklyplan_id'] ?? 0);
                                            // preserve raw YYYY-MM-DD strings for accurate display
                                            $startdate = $row['startdate'] ?? '';
                                            $teacher_id = (int) ($row['teacher_id'] ?? 0);
                                            $enddate = $row['enddate'] ?? '';
                                            $periodsperweek = $row['periodsperweek'] ?? '';
                                            $bookpages = $row['bookpages'] ?? '';
                                            $term_value = (int) ($row['term'] ?? 0);
                                            $terms = mysqli_query($con, "SELECT * FROM financialterms WHERE status=1 AND financialterm_id={$term_value}");
                                            $row2 = $terms ? mysqli_fetch_assoc($terms) : null;
                                            $term = $row2['term'] ?? '';
                                            $year = $row2['year'] ?? '';
                                            // get teacher name 
                                            $teacher = mysqli_query($con, "SELECT * FROM teachers WHERE teacher_id={$teacher_id}");
                                            $row3 = $teacher ? mysqli_fetch_assoc($teacher) : null;
                                            $teachername = $row3['fullname'] ?? '';
                                    ?>
                                        <tr class="gradeA">
                                            <td><?php echo htmlspecialchars(normalize_date_for_display($startdate)); ?></td>
                                            <td><?php echo htmlspecialchars(normalize_date_for_display($enddate)); ?></td>
                                            <td>Term <?php echo htmlspecialchars($term); ?></td>                                           
                                            <td><?php echo htmlspecialchars($year); ?></td>
                                            <td><?php echo htmlspecialchars($periodsperweek); ?></td>
                                            <td><?php echo htmlspecialchars($teachername); ?></td>
                                            <td><a href="weeklyplan?id=<?php echo $weeklyplan_id; ?>" target="_blank" class="btn btn-success btn-xs">Details</a>
                                                <!--<a href="editweeklyplan?id=<?php echo $weeklyplan_id; ?>" class="btn btn-info btn-xs">Edit</a>-->
                                                <!-- <a href="removeweeklyplan?id=<?php echo $weeklyplan_id; ?>" class="btn btn-danger btn-xs" onclick="return confirm_delete<?php echo $weeklyplan_id; ?>()">Remove</a> -->
                                            </td>
                                        </tr>
                                        <script type="text/javascript">
                                            function confirm_delete<?php echo $weeklyplan_id; ?>() {
                                                return confirm('You are about To Remove this Student. Are you sure you want to proceed?');
                                            }
                                        </script>
                                    <?php } } ?>
                                </tbody>
                            </table>

                        </div>
                    </section>
                </div>

            </div>
            <?php } ?>
        </section>
        <!--body wrapper end-->

        <!--footer section start-->

        <!--footer section end-->


        </div>
        <!-- main content end-->
    </section>
    <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
    <script type="text/javascript" language="javascript" src="<?php echo BASE_URL; ?>/js/advanced-datatable/js/jquery.dataTables.js"></script>
    <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/dynamic_table_init.js"></script>
    <script src="js/chosen/chosen.jquery.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
    <script>
        var config = {
            '.chosen-select': {},
            '.chosen-select-deselect': {
                allow_single_deselect: true
            },
            '.chosen-select-no-single': {
                disable_search_threshold: 10
            },
            '.chosen-select-no-results': {
                no_results_text: 'Oops, nothing found!'
            },
            '.chosen-select-width': {
                width: "95%"
            }
        }
        for (var selector in config) {
            $(selector).chosen(config[selector]);
        }
    </script>
</body>

</html>