<?php
include 'includes/conn.php';
include 'includes/roles.php';

// Normalize session role level
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);

if (!canManageVendors($user_level)) {
    header('Location:login.php');
    exit();
}

$contract_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($contract_id <= 0) {
    $_SESSION['message'] = 'Invalid contract id.';
    $_SESSION['msg_type'] = 'danger';
    header('Location: vendorcontracts.php');
    exit();
}

$sql = "SELECT vc.*, v.vendor_name, v.vendor_code FROM vendor_contracts vc LEFT JOIN vendors v ON vc.vendor_id=v.vendor_id WHERE vc.contract_id = '" . intval($contract_id) . "' LIMIT 1";
$res = mysqli_query($con, $sql);
if (!$res || mysqli_num_rows($res) === 0) {
    $_SESSION['message'] = 'Contract not found.';
    $_SESSION['msg_type'] = 'warning';
    header('Location: vendorcontracts.php');
    exit();
}

$contract = mysqli_fetch_assoc($res);

?>
<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <title>View Contract</title>
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
    <style>.contract-label{font-weight:700;width:200px;display:inline-block}</style>
</head>
<body class="sticky-header">
<?php include 'includes/header.php'; ?>
<section class="wrapper">
    <div class="row">
        <div class="col-lg-10">
            <section class="panel">
                <header class="panel-heading">Contract Details</header>
                <div class="panel-body">
                    <p>
                        <span class="contract-label">Vendor</span>: <?php echo htmlspecialchars($contract['vendor_name'] . ' (' . ($contract['vendor_code'] ?? 'N/A') . ')'); ?><br>
                        <span class="contract-label">Title</span>: <?php echo htmlspecialchars($contract['contract_title']); ?><br>
                        <span class="contract-label">Contract #</span>: <?php echo htmlspecialchars($contract['contract_number'] ?? '-'); ?><br>
                        <span class="contract-label">Start Date</span>: <?php echo htmlspecialchars($contract['start_date']); ?><br>
                        <span class="contract-label">End Date</span>: <?php echo htmlspecialchars($contract['end_date'] ?? '-'); ?><br>
                        <span class="contract-label">Total Value</span>: <?php echo htmlspecialchars(number_format((float)$contract['total_contract_value'],2)); ?><br>
                        <span class="contract-label">Status</span>: <?php echo htmlspecialchars($contract['status']); ?><br>
                        <span class="contract-label">Renewal Reminder</span>: <?php echo htmlspecialchars($contract['renewal_reminder_date'] ?? '-'); ?><br>
                    </p>
                    <h5>Terms</h5>
                    <div class="well"><?php echo nl2br(htmlspecialchars($contract['contract_terms'] ?? '-')); ?></div>

                    <p>
                        <a href="vendorcontracts.php?id=<?php echo (int)$contract['vendor_id']; ?>" class="btn btn-default">Back to Contracts</a>
                        <?php if (hasFullFinancialPermissions($_SESSION['schoolsyslevel'] ?? 0)) { ?>
                            <a href="editvendorcontract.php?id=<?php echo (int)$contract['contract_id']; ?>" class="btn btn-info">Edit</a>
                            <a href="deletevendorcontract.php?id=<?php echo (int)$contract['contract_id']; ?>" class="btn btn-danger" onclick="return confirm('Delete this contract?');">Delete</a>
                        <?php } ?>
                    </p>

                </div>
            </section>
        </div>
    </div>
</section>
</body>
</html>
