<?php
include 'includes/conn.php';
include 'includes/roles.php';

// Accept legacy session keys
$session_user = $_SESSION['user_id'] ?? $_SESSION['schoolsys'] ?? null;
if (empty($session_user)) {
    header('Location: login.php');
    exit();
}

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) {
    echo "<h3>Invalid requisition ID.</h3>";
    exit();
}

// Fetch requisition
$sql = "SELECT sr.*, u.username as requester, a.username as approver
        FROM stock_requisitions sr
        LEFT JOIN users u ON sr.requested_by = u.user_id
        LEFT JOIN users a ON sr.approved_by = a.user_id
        WHERE sr.requisition_id = ? LIMIT 1";
$stmt = mysqli_prepare($con, $sql);
if (!$stmt) {
    echo "Failed to prepare statement: " . htmlspecialchars(mysqli_error($con));
    exit();
}
mysqli_stmt_bind_param($stmt, 'i', $id);
mysqli_stmt_execute($stmt);
$res = mysqli_stmt_get_result($stmt);
$req = mysqli_fetch_assoc($res);
mysqli_stmt_close($stmt);

if (!$req) {
    echo "<h3>Requisition not found.</h3>";
    exit();
}

// Parse items JSON if present
$items = [];
if (!empty($req['requisition_items'])) {
    $decoded = json_decode($req['requisition_items'], true);
    if (json_last_error() === JSON_ERROR_NONE && is_array($decoded)) {
        $items = $decoded;
    }
}

?><!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Requisition - <?php echo htmlspecialchars($req['requisition_number']); ?></title>
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
    <?php include 'includes/header.php'; ?>
    <section class="wrapper">
        <div class="row">
            <div class="col-lg-12">
                <section class="panel">
                    <header class="panel-heading">
                        <h4 class="panel-title"><i class="fa fa-eye"></i> View Requisition</h4>
                    </header>
                    <div class="panel-body">
                        <p><strong>Requisition #:</strong> <?php echo htmlspecialchars($req['requisition_number']); ?></p>
                        <p><strong>Requested By:</strong> <?php echo htmlspecialchars($req['requester'] ?? '-'); ?></p>
                        <p><strong>Date Requested:</strong> <?php echo ($req['requested_date'] ? date('d/M/Y', strtotime($req['requested_date'])) : '-'); ?></p>
                        <p><strong>Total Items:</strong> <?php echo (int)$req['total_items']; ?></p>
                        <p><strong>Purpose:</strong> <?php echo nl2br(htmlspecialchars($req['purpose'] ?? '')); ?></p>
                        <p><strong>Status:</strong> <?php echo htmlspecialchars($req['approval_status'] ?? '-'); ?></p>
                        <p><strong>Approved By:</strong> <?php echo htmlspecialchars($req['approver'] ?? '-'); ?></p>
                        <p><strong>Approval Date:</strong> <?php echo ($req['approval_date'] ? date('d/M/Y', strtotime($req['approval_date'])) : '-'); ?></p>

                        <h5>Items</h5>
                        <?php if (!empty($items)): ?>
                            <table class="table table-striped">
                                <thead>
                                    <tr><th>#</th><th>Item ID</th><th>Qty</th><th>Notes</th></tr>
                                </thead>
                                <tbody>
                                <?php foreach ($items as $i => $it): ?>
                                    <tr>
                                        <td><?php echo $i+1; ?></td>
                                        <td><?php echo htmlspecialchars($it['item_id'] ?? ($it['id'] ?? '-')); ?></td>
                                        <td><?php echo htmlspecialchars($it['qty'] ?? ($it['quantity'] ?? '-')); ?></td>
                                        <td><?php echo htmlspecialchars($it['notes'] ?? ''); ?></td>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>
                            </table>
                        <?php else: ?>
                            <p>No structured items found. Raw data:</p>
                            <pre><?php echo htmlspecialchars($req['requisition_items']); ?></pre>
                        <?php endif; ?>

                        <a href="stockrequisitions.php" class="btn btn-default">Back to list</a>
                    </div>
                </section>
            </div>
        </div>
    </section>
</section>

<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
</body>
</html>
