<?php
include 'includes/conn.php';
if (!isset($_SESSION['schoolsys']) || (int)$_SESSION['schoolsyslevel'] !== 1) {
  header('Location: login.php');
  exit;
}

$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) {
  header('Location: notices.php');
  exit;
}

// Fetch notice details
$stmt = mysqli_prepare($con, "SELECT financialterm_id, term, year, academic_year, important_notice, status FROM financialterms WHERE financialterm_id = ?");
if ($stmt) {
  mysqli_stmt_bind_param($stmt, 'i', $id);
  mysqli_stmt_execute($stmt);
  $result = mysqli_stmt_get_result($stmt);
  $row = mysqli_fetch_assoc($result);
  
  if (!$row) {
    header('Location: notices.php');
    exit;
  }
  
  $term = (int)$row['term'];
  $year = $row['year'] ?? '';
  $acad_year = $row['academic_year'] ?? '';
  $notice = $row['important_notice'] ?? '';
  $status = (int)$row['status'];
  
  mysqli_stmt_close($stmt);
} else {
  header('Location: notices.php');
  exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>View Important Notice | School Manager</title>
  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
</head>

<body class="sticky-header">
<section>
  <?php include 'includes/header.php'; ?>

  <section class="wrapper">
    <div class="row">
      <div class="col-lg-8">
        <section class="panel">
          <header class="panel-heading">
            Important Notice - Term <?php echo $term . ' ' . $acad_year; ?>
            <span class="tools pull-right">
              <a href="editnotice.php?id=<?php echo $id; ?>" class="btn btn-primary btn-sm"><i class="fa fa-edit"></i> Edit</a>
              <a href="notices.php" class="btn btn-default btn-sm"><i class="fa fa-arrow-left"></i> Back</a>
            </span>
          </header>
          <div class="panel-body">
            <div class="form-horizontal">
              <div class="form-group">
                <label class="col-sm-3 control-label"><strong>Term:</strong></label>
                <div class="col-sm-9">
                  <p class="form-control-static">Term <?php echo $term; ?></p>
                </div>
              </div>
              
              <div class="form-group">
                <label class="col-sm-3 control-label"><strong>Academic Year:</strong></label>
                <div class="col-sm-9">
                  <p class="form-control-static"><?php echo htmlspecialchars($acad_year); ?></p>
                </div>
              </div>
              
              <div class="form-group">
                <label class="col-sm-3 control-label"><strong>Status:</strong></label>
                <div class="col-sm-9">
                  <p class="form-control-static">
                    <?php echo $status == 1 ? '<span class="badge badge-success">Active</span>' : '<span class="badge badge-default">Inactive</span>'; ?>
                  </p>
                </div>
              </div>
              
              <hr>
              
              <div class="form-group">
                <label class="col-sm-3 control-label"><strong>Important Notice:</strong></label>
                <div class="col-sm-9">
                  <div class="well">
                    <?php echo !empty($notice) ? nl2br(htmlspecialchars($notice)) : '<em class="text-muted">No important notice set for this term</em>'; ?>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </section>
      </div>
    </div>
  </section>
</section>

<script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
</body>
</html>
