<?php
include 'includes/conn.php';
include 'includes/roles.php';

// Authorization
if (!hasFinancialAccess($_SESSION['schoolsyslevel'])) {
    header('Location:login.php');
    exit();
}

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) {
    http_response_code(404);
    echo "<h3>Fee structure not found (invalid id).</h3>";
    exit;
}

// Try to load the fee structure (use try/catch to avoid fatal exception if ref tables missing)
$fs = null;
try {
    $sql = "SELECT fs.*, y.year, t.term, c.class, u.username
            FROM fee_structures fs
            LEFT JOIN academicyears y ON fs.academic_year_id = y.academicyear_id
            LEFT JOIN financialterms t ON fs.term_id = t.financialterm_id
            LEFT JOIN classes c ON fs.class_id = c.class_id
            LEFT JOIN users u ON fs.created_by = u.user_id
            WHERE fs.fee_structure_id = " . $id . " LIMIT 1";
    $res = mysqli_query($con, $sql);
    if ($res && mysqli_num_rows($res) > 0) {
        $fs = mysqli_fetch_assoc($res);
    }
} catch (mysqli_sql_exception $e) {
    // If join query fails (missing tables), fall back to simple select
    $sql = "SELECT * FROM fee_structures WHERE fee_structure_id = " . $id . " LIMIT 1";
    $res = mysqli_query($con, $sql);
    if ($res && mysqli_num_rows($res) > 0) {
        $fs = mysqli_fetch_assoc($res);
    }
}

if (!$fs) {
    http_response_code(404);
    echo "<h3>Fee structure not found.</h3>";
    exit;
}

?><!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>View Fee Structure</title>
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
    <?php include 'includes/header.php'; ?>
    <section class="wrapper">
        <div class="row">
            <div class="col-lg-8 col-lg-offset-2">
                <section class="panel">
                    <header class="panel-heading">
                        <h4 class="panel-title"><i class="fa fa-credit-card"></i> Fee Structure Details</h4>
                    </header>
                    <div class="panel-body">
                        <table class="table table-striped table-bordered">
                            <tbody>
                                <tr><th>Structure Name</th><td><?php echo htmlspecialchars($fs['structure_name'] ?? ''); ?></td></tr>
                                <tr><th>Academic Year</th><td><?php echo htmlspecialchars($fs['year'] ?? ($fs['academic_year_id'] ?? '-')); ?></td></tr>
                                <tr><th>Term</th><td><?php echo htmlspecialchars($fs['term'] ?? ($fs['term_id'] ?? '-')); ?></td></tr>
                                <tr><th>Class</th><td><?php echo htmlspecialchars($fs['class'] ?? ($fs['class_id'] ?? '-')); ?></td></tr>
                                <tr><th>Stream</th><td><?php echo htmlspecialchars($fs['stream_id'] ?? '-'); ?></td></tr>
                                <tr><th>Base Tuition Fee</th><td><?php echo isset($fs['base_tuition_fee']) ? number_format($fs['base_tuition_fee'],2) : '0.00'; ?></td></tr>
                                <tr><th>Boarding Fee</th><td><?php echo isset($fs['boarding_fee']) ? number_format($fs['boarding_fee'],2) : '0.00'; ?></td></tr>
                                <tr><th>Activity Fee</th><td><?php echo isset($fs['activity_fee']) ? number_format($fs['activity_fee'],2) : '0.00'; ?></td></tr>
                                <tr><th>Examination Fee</th><td><?php echo isset($fs['examination_fee']) ? number_format($fs['examination_fee'],2) : '0.00'; ?></td></tr>
                                <tr><th>Technology Fee</th><td><?php echo isset($fs['technology_fee']) ? number_format($fs['technology_fee'],2) : '0.00'; ?></td></tr>
                                <tr><th>Sports Fee</th><td><?php echo isset($fs['sports_fee']) ? number_format($fs['sports_fee'],2) : '0.00'; ?></td></tr>
                                <tr><th>Other Fees</th><td><?php echo isset($fs['other_fees']) ? number_format($fs['other_fees'],2) : '0.00'; ?></td></tr>
                                <tr><th>Total Fee</th><td><?php echo isset($fs['total_fee']) ? number_format($fs['total_fee'],2) : '0.00'; ?></td></tr>
                                <tr><th>Description</th><td><?php echo nl2br(htmlspecialchars($fs['description'] ?? '')); ?></td></tr>
                                <tr><th>Status</th><td><?php echo (isset($fs['status']) && $fs['status']==1) ? 'Active' : 'Inactive'; ?></td></tr>
                                <tr><th>Created By</th><td><?php echo htmlspecialchars($fs['username'] ?? ($fs['created_by'] ?? '-')); ?></td></tr>
                                <tr><th>Created At</th><td><?php echo htmlspecialchars($fs['created_at'] ?? ''); ?></td></tr>
                            </tbody>
                        </table>
                        <p>
                            <a href="feestructures.php" class="btn btn-default">Back to list</a>
                            <?php if (hasFullFinancialPermissions($_SESSION['schoolsyslevel'])) { ?>
                                <a href="editfeestructure.php?id=<?php echo $id; ?>" class="btn btn-primary">Edit</a>
                                <a href="deletefeestructure.php?id=<?php echo $id; ?>" class="btn btn-danger" onclick="return confirm('Are you sure?')">Delete</a>
                            <?php } ?>
                        </p>
                    </div>
                </section>
            </div>
        </div>
    </section>
</section>
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
</body>
</html>
