<?php
include 'includes/conn.php';
include 'includes/roles.php';
// Normalize session role level: support both legacy `secusyslevel` and `schoolsyslevel`
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);

// Check authorization
if (!canManageVendors($user_level)) {
    header('Location:login.php');
    exit();
}

$search = $_GET['search'] ?? '';
$category_filter = $_GET['category'] ?? '';

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <link rel="shortcut icon" href="#" type="image/png">
    <title>Vendor Management</title>
    <link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
    <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
    <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
    <?php include 'includes/header.php'; ?>
    <section class="wrapper">
        <div class="row">
            <div class="col-lg-12">
                <section class="panel">
                    <header class="panel-heading">
                        <h4 class="panel-title">
                            <i class="fa fa-handshake-o"></i> Vendor Management
                        </h4>
                    </header>
                    <div class="panel-body">
                        <?php
                        if (isset($_SESSION['message'])) {
                            echo '<div class="alert alert-' . (isset($_SESSION['msg_type']) ? $_SESSION['msg_type'] : 'info') . ' alert-dismissible">
                                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                                    ' . htmlspecialchars($_SESSION['message']) . '
                                 </div>';
                            unset($_SESSION['message']);
                            unset($_SESSION['msg_type']);
                        }
                        ?>
                        
                        <a href="addvendor.php" class="btn btn-primary btn-sm margin-bottom-10">
                            <i class="fa fa-plus"></i> Add New Vendor
                        </a>
                        
                        <!-- Search and Filters -->
                        <div class="row margin-bottom-20">
                            <div class="col-md-6">
                                <form method="GET" class="form-inline">
                                    <input type="text" name="search" class="form-control" placeholder="Search vendor name or contact..." value="<?php echo htmlspecialchars($search); ?>">
                                    <button type="submit" class="btn btn-default"><i class="fa fa-search"></i></button>
                                </form>
                            </div>
                            <div class="col-md-6">
                                <select class="form-control" onchange="location = '?category=' + this.value;">
                                    <option value="">All Categories</option>
                                    <?php
                                    $categories = mysqli_query($con, "SELECT DISTINCT category FROM vendors WHERE status=1 AND category IS NOT NULL ORDER BY category");
                                    while ($cat = mysqli_fetch_array($categories)) {
                                        echo '<option value="' . htmlspecialchars($cat['category']) . '"' . ($category_filter == $cat['category'] ? ' selected' : '') . '>' . htmlspecialchars($cat['category']) . '</option>';
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>
                        
                        <table class="display table table-striped" id="dynamic-table">
                            <thead>
                                <tr>
                                    <th>Vendor Name</th>
                                    <th>Contact Person</th>
                                    <th>Email</th>
                                    <th>Phone</th>
                                    <th>Category</th>
                                    <th>Payment Terms</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $query = "SELECT * FROM vendors WHERE status=1";
                                
                                if ($search) {
                                    $search = mysqli_real_escape_string($con, $search);
                                    $query .= " AND (vendor_name LIKE '%$search%' OR contact_person LIKE '%$search%' OR email LIKE '%$search%')";
                                }
                                if ($category_filter) {
                                    $category_filter = mysqli_real_escape_string($con, $category_filter);
                                    $query .= " AND category = '$category_filter'";
                                }
                                
                                $query .= " ORDER BY vendor_name";
                                
                                $result = mysqli_query($con, $query);
                                if ($result && mysqli_num_rows($result) > 0) {
                                    while ($row = mysqli_fetch_array($result)) {
                                        echo '<tr>
                                            <td><strong>' . htmlspecialchars($row['vendor_name']) . '</strong><br><small>' . htmlspecialchars($row['vendor_code'] ?? 'N/A') . '</small></td>
                                            <td>' . htmlspecialchars($row['contact_person'] ?? '-') . '</td>
                                            <td><a href="mailto:' . htmlspecialchars($row['email']) . '">' . htmlspecialchars($row['email'] ?? '-') . '</a></td>
                                            <td>' . htmlspecialchars($row['phone'] ?? '-') . '</td>
                                            <td>' . htmlspecialchars($row['category'] ?? '-') . '</td>
                                            <td>' . htmlspecialchars($row['payment_terms'] ?? '-') . '</td>
                                            <td><span class="label label-success">Active</span></td>
                                            <td>
                                                <a href="editvendor.php?id=' . $row['vendor_id'] . '" class="btn btn-info btn-xs"><i class="fa fa-edit"></i> Edit</a>
                                                <a href="vendorcontracts.php?id=' . $row['vendor_id'] . '" class="btn btn-primary btn-xs"><i class="fa fa-file"></i> Contracts</a>
                                                <a href="vendorinvoices.php?id=' . $row['vendor_id'] . '" class="btn btn-success btn-xs"><i class="fa fa-money"></i> Invoices</a>';
                                        if (hasFullFinancialPermissions($_SESSION['schoolsyslevel'])) {
                                            echo '<a href="deactivatevendor.php?id=' . $row['vendor_id'] . '" class="btn btn-warning btn-xs" onclick="return confirm(\'Deactivate vendor?\')"><i class="fa fa-ban"></i></a>';
                                        }
                                        echo '</td>
                                        </tr>';
                                    }
                                } else {
                                    echo '<tr><td colspan="8" class="text-center">No vendors found</td></tr>';
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </section>
            </div>
        </div>
    </section>
</section>

<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
<script src="js/dynamic_table_init.js"></script>
<script src="js/scripts.js"></script>
</body>
</html>
