<?php
include 'includes/conn.php';
include 'includes/roles.php';

if (!canViewFinancialReports($_SESSION['schoolsyslevel'])) {
    header('Location:login.php');
    exit();
}

$start_date = $_GET['start_date'] ?? date('Y-m-01');
$end_date = $_GET['end_date'] ?? date('Y-m-d');
$start_safe = mysqli_real_escape_string($con, $start_date);
$end_safe = mysqli_real_escape_string($con, $end_date);

// Candidate vendor payment tables and likely columns
$candidates = [
    'accounts_payable' => ['vendor' => ['vendor_name','vendor','supplier_name','name'], 'amount' => ['amount','amount_paid','paid'], 'date' => ['due_date','payment_date','created_at','date']],
    'vendor_payments' => ['vendor' => ['vendor_name','vendor','supplier'], 'amount' => ['amount','paid_amount','amount_paid'], 'date' => ['payment_date','created_at','date']],
    'vendorpayment' => ['vendor' => ['vendor_name','vendor'], 'amount' => ['amount','paid_amount'], 'date' => ['payment_date','created_at','date']]
];

function table_exists_local($con, $table){
    $t = mysqli_real_escape_string($con, $table);
    $r = @mysqli_query($con, "SHOW TABLES LIKE '".$t."'");
    return $r && mysqli_num_rows($r) > 0;
}

function find_column_local($con, $db, $table, $candidates){
    foreach ($candidates as $col){
        $colEsc = mysqli_real_escape_string($con, $col);
        $q = "SELECT COUNT(*) AS cnt FROM information_schema.COLUMNS WHERE TABLE_SCHEMA='".mysqli_real_escape_string($con,$db)."' AND TABLE_NAME='".mysqli_real_escape_string($con,$table)."' AND COLUMN_NAME='".$colEsc."'";
        $r = @mysqli_query($con, $q);
        if ($r){ $row = mysqli_fetch_assoc($r); if ((int)$row['cnt'] > 0) return $col; }
    }
    return false;
}

$dbNameRes = mysqli_query($con, "SELECT DATABASE() as db");
$dbName = $dbNameRes ? mysqli_fetch_assoc($dbNameRes)['db'] : '';

$payments = [];
$total = 0.0;

foreach ($candidates as $table => $map) {
    if (!table_exists_local($con, $table)) continue;
    $vendorCol = find_column_local($con, $dbName, $table, $map['vendor']);
    $amountCol = find_column_local($con, $dbName, $table, $map['amount']);
    $dateCol = find_column_local($con, $dbName, $table, $map['date']);
    if (!$amountCol || !$dateCol) continue; // need amount and date at minimum

    // detect if date is stored as int/unix
    $isInt = false;
    $colInfo = @mysqli_query($con, "SHOW COLUMNS FROM `".mysqli_real_escape_string($con,$table)."` LIKE '".mysqli_real_escape_string($con,$dateCol)."'");
    if ($colInfo && ($ci = mysqli_fetch_assoc($colInfo))){ $type = strtolower($ci['Type'] ?? ''); if (strpos($type,'int') !== false) $isInt = true; }

    if ($isInt) {
        $dateExpr = "FROM_UNIXTIME(`".$dateCol."`)";
        $whereDate = "$dateExpr >= '$start_safe' AND $dateExpr <= '$end_safe'";
    } else {
        $dateExpr = "`".$dateCol."`";
        $whereDate = "DATE($dateExpr) >= '$start_safe' AND DATE($dateExpr) <= '$end_safe'";
    }

    $selectParts = [];
    $selectParts[] = $vendorCol ? "`".$vendorCol."` AS vendor" : "NULL AS vendor";
    $selectParts[] = "`".$amountCol."` AS amount";
    $selectParts[] = "$dateExpr AS paid_at";
    $selectParts[] = "'".mysqli_real_escape_string($con,$table)."' AS source";

    $sql = "SELECT " . implode(', ', $selectParts) . " FROM `".mysqli_real_escape_string($con,$table)."` WHERE " . $whereDate . " LIMIT 1000";
    $r = @mysqli_query($con, $sql);
    if ($r){
        while ($row = mysqli_fetch_assoc($r)){
            $amt = (float) ($row['amount'] ?? 0);
            $dt = $row['paid_at'] ?? '';
            if (is_numeric($dt)) $dt = date('Y-m-d H:i:s',(int)$dt);
            $payments[] = ['vendor' => $row['vendor'] ?? 'N/A', 'amount' => $amt, 'date' => $dt, 'source' => $row['source'] ?? $table];
            $total += $amt;
        }
        break; // use first matching table to avoid duplicates
    }
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <link rel="shortcut icon" href="#" type="image/png">
    <title>Vendor Payment Report</title>
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
    <?php include 'includes/header.php'; ?>
    <section class="wrapper">
        <div class="row">
            <div class="col-lg-12">
                <section class="panel">
                    <header class="panel-heading">
                        <h4 class="panel-title"><i class="fa fa-truck"></i> Vendor Payments: <?php echo htmlspecialchars($start_date); ?> — <?php echo htmlspecialchars($end_date); ?></h4>
                    </header>
                    <div class="panel-body">
                        <div class="row margin-bottom-20">
                            <div class="col-md-4">
                                <strong>Total Vendor Payments:</strong>
                                <h3 class="text-danger"><?php echo number_format($total,2); ?></h3>
                            </div>
                            <div class="col-md-8 text-right">
                                <a href="financialreports.php?start_date=<?php echo urlencode($start_date); ?>&end_date=<?php echo urlencode($end_date); ?>" class="btn btn-default">Back to Reports</a>
                            </div>
                        </div>

                        <table class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Vendor</th>
                                    <th>Amount</th>
                                    <th>Date</th>
                                    <th>Source</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (empty($payments)) { ?>
                                    <tr><td colspan="5">No vendor payments found for the selected period.</td></tr>
                                <?php } else { $i=1; foreach ($payments as $p) { ?>
                                    <tr>
                                        <td><?php echo $i++; ?></td>
                                        <td><?php echo htmlspecialchars($p['vendor']); ?></td>
                                        <td><?php echo number_format($p['amount'],2); ?></td>
                                        <td><?php echo htmlspecialchars($p['date']); ?></td>
                                        <td><?php echo htmlspecialchars($p['source']); ?></td>
                                    </tr>
                                <?php } } ?>
                            </tbody>
                        </table>

                    </div>
                </section>
            </div>
        </div>
    </section>
</section>
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/scripts.js"></script>
</body>
</html>
