<?php
include 'includes/conn.php';
include 'includes/roles.php';
if (session_status() === PHP_SESSION_NONE) { session_start(); }
// Normalize session role level: support both legacy `secusyslevel` and `schoolsyslevel`
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
if (!hasFinancialAccess($user_level)) { header('Location:login.php'); exit; }

$vendorId = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$neededTables = ['vendors','accounts_payable'];
foreach ($neededTables as $tbl) {
    $check = mysqli_query($con, "SHOW TABLES LIKE '$tbl'");
    if (!$check || mysqli_num_rows($check) === 0) { die("$tbl table not found. Run create_accounting_tables.sql"); }
}
if ($vendorId <= 0) { header('Location: vendors.php'); exit; }

$vendorRes = mysqli_query($con, "SELECT * FROM vendors WHERE vendor_id=$vendorId LIMIT 1");
$vendor = mysqli_fetch_assoc($vendorRes);
if (!$vendor) { die('Vendor not found'); }

// Backwards-compatible alias for templates expecting 'name'
if (isset($vendor['vendor_name']) && !isset($vendor['name'])) {
  $vendor['name'] = $vendor['vendor_name'];
}

$invoiceRes = mysqli_query($con, "SELECT * FROM accounts_payable WHERE vendor_id=$vendorId ORDER BY due_date DESC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Vendor Invoices</title>
  <link rel="stylesheet" href="css/style.css">
  <link rel="stylesheet" href="css/style-responsive.css">
  <link rel="stylesheet" href="assets/advanced-datatable/media/css/demo_page.css" />
  <link rel="stylesheet" href="assets/advanced-datatable/media/css/demo_table.css" />
  <link rel="stylesheet" href="assets/data-tables/DT_bootstrap.css" />
</head>
<body class="sticky-header">
<section>
  <?php include 'includes/header.php'; ?>
  <section class="wrapper">
    <div class="row">
      <div class="col-lg-12">
        <section class="panel">
          <header class="panel-heading">
            <h3><i class="fa fa-file-text-o"></i> Invoices for <?php echo htmlspecialchars($vendor['name']); ?></h3>
            <a href="vendors.php" class="btn btn-default btn-sm" style="margin-top:10px;">Back</a>
          </header>
          <div class="panel-body">
            <div class="adv-table">
              <table class="display table table-bordered table-striped" id="dynamic-table">
                <thead>
                  <tr>
                    <th>Invoice #</th>
                    <th>Issue Date</th>
                    <th>Due Date</th>
                    <th>Amount</th>
                    <th>Status</th>
                    <th>Description</th>
                  </tr>
                </thead>
                <tbody>
                  <?php while ($inv = mysqli_fetch_assoc($invoiceRes)) { ?>
                  <tr>
                    <td><?php echo htmlspecialchars($inv['invoice_number']); ?></td>
                    <td><?php echo htmlspecialchars($inv['invoice_date']); ?></td>
                    <td><?php echo htmlspecialchars($inv['due_date']); ?></td>
                    <td><?php echo number_format((float)$inv['amount'], 2); ?></td>
                    <td><?php echo htmlspecialchars($inv['status']); ?></td>
                    <td><?php echo htmlspecialchars($inv['description']); ?></td>
                  </tr>
                  <?php } ?>
                </tbody>
              </table>
            </div>
          </div>
        </section>
      </div>
    </div>
  </section>
</section>
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script type="text/javascript" language="javascript" src="assets/advanced-datatable/media/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="assets/data-tables/DT_bootstrap.js"></script>
<script src="js/dynamic_table_init.js"></script>
</body>
</html>