<?php
include 'includes/conn.php';
include 'includes/roles.php';

// Normalize session role level
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
if (!canManageVendors($user_level)) {
    header('Location:login.php');
    exit();
}

$vendorId = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($vendorId <= 0) {
    header('Location:vendors.php');
    exit();
}

$vendorRes = mysqli_query($con, "SELECT * FROM vendors WHERE vendor_id='" . $vendorId . "' LIMIT 1");
$vendor = $vendorRes ? mysqli_fetch_assoc($vendorRes) : null;

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <title>Vendor Contracts</title>
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
    <?php include 'includes/header.php'; ?>
    <section class="wrapper">
        <div class="row">
            <div class="col-lg-12">
                <section class="panel">
                    <header class="panel-heading">
                        Vendor Contracts for <?php echo htmlspecialchars($vendor['vendor_name'] ?? 'Vendor'); ?>
                    </header>
                    <div class="panel-body">
                        <a href="vendors.php" class="btn btn-default btn-sm">&larr; Back to Vendors</a>
                        <a href="addvendorcontract.php?vendor_id=<?php echo $vendorId; ?>" class="btn btn-primary btn-sm">Add Contract</a>
                        <hr/>
                        <?php
                        $contracts = mysqli_query($con, "SELECT * FROM vendor_contracts WHERE vendor_id='" . $vendorId . "' ORDER BY start_date DESC");
                        if ($contracts && mysqli_num_rows($contracts) > 0) {
                        ?>
                        <table class="table table-striped">
                            <thead>
                                <tr><th>Title</th><th>Contract #</th><th>Start</th><th>End</th><th>Value</th><th>Status</th><th>Action</th></tr>
                            </thead>
                            <tbody>
                            <?php while ($c = mysqli_fetch_assoc($contracts)) { ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($c['contract_title']); ?></td>
                                    <td><?php echo htmlspecialchars($c['contract_number']); ?></td>
                                    <td><?php echo htmlspecialchars($c['start_date']); ?></td>
                                    <td><?php echo htmlspecialchars($c['end_date']); ?></td>
                                    <td><?php echo number_format((float)$c['total_contract_value'],2); ?></td>
                                    <td><?php echo htmlspecialchars($c['status']); ?></td>
                                    <td>
                                        <a href="viewvendorcontract.php?id=<?php echo $c['contract_id']; ?>" class="btn btn-info btn-xs">View</a>
                                        <?php if (hasFullFinancialPermissions($_SESSION['schoolsyslevel'])) { ?>
                                            <a href="editvendorcontract.php?id=<?php echo $c['contract_id']; ?>" class="btn btn-warning btn-xs">Edit</a>
                                        <?php } ?>
                                    </td>
                                </tr>
                            <?php } ?>
                            </tbody>
                        </table>
                        <?php } else { ?>
                            <div class="alert alert-info">No contracts found for this vendor.</div>
                        <?php } ?>
                    </div>
                </section>
            </div>
        </div>
    </section>
</section>
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
</body>
</html>
