<?php
include 'includes/conn.php';
include 'includes/roles.php';
if (session_status() === PHP_SESSION_NONE) { session_start(); }
// Normalize session role level: support both legacy `secusyslevel` and `schoolsyslevel`
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
if (!hasFinancialAccess($user_level)) { header('Location:login.php'); exit; }

$vendorId = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$tableCheck = mysqli_query($con, "SHOW TABLES LIKE 'vendors'");
if (!$tableCheck || mysqli_num_rows($tableCheck) === 0) { die('vendors table not found.'); }
if ($vendorId <= 0) { header('Location: vendors.php'); exit; }

$vendorQ = mysqli_query($con, "SELECT * FROM vendors WHERE vendor_id=$vendorId LIMIT 1");
$vendor = mysqli_fetch_assoc($vendorQ);
if (!$vendor) { die('Vendor not found'); }
// Backwards-compatible alias: some templates expect 'name'
if (isset($vendor['vendor_name']) && !isset($vendor['name'])) {
  $vendor['name'] = $vendor['vendor_name'];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Vendor Contacts</title>
  <link rel="stylesheet" href="css/style.css">
  <link rel="stylesheet" href="css/style-responsive.css">
</head>
<body class="sticky-header">
<section>
  <?php include 'includes/header.php'; ?>
  <section class="wrapper">
    <div class="row">
      <div class="col-lg-10 col-lg-offset-1">
        <section class="panel">
          <header class="panel-heading">
            <h3><i class="fa fa-address-book"></i> Contacts for <?php echo htmlspecialchars($vendor['name']); ?></h3>
            <a href="vendors.php" class="btn btn-default btn-sm" style="margin-top:10px;">Back</a>
          </header>
          <div class="panel-body">
            <p><strong>Contact Person:</strong> <?php echo htmlspecialchars($vendor['contact_person']); ?></p>
            <p><strong>Email:</strong> <?php echo htmlspecialchars($vendor['email']); ?></p>
            <p><strong>Phone:</strong> <?php echo htmlspecialchars($vendor['phone']); ?></p>
            <p><strong>Address:</strong><br><?php echo nl2br(htmlspecialchars($vendor['address'])); ?></p>
            <p><strong>Payment Terms:</strong> <?php echo htmlspecialchars($vendor['payment_terms']); ?></p>
            <p><strong>Status:</strong> <?php echo ((int)$vendor['status']===1?'Active':'Inactive'); ?></p>
            <div class="alert alert-info">No separate contacts table detected; displaying vendor contact details stored on the vendor record.</div>
          </div>
        </section>
      </div>
    </div>
  </section>
</section>
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
</body>
</html>