<?php
session_start();
include 'includes/conn.php';
include 'includes/roles.php';

$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
if (!hasFinancialAccess($user_level) && $user_level !== 2) {
    header('Location: index.php');
    exit;
}

// Handle search and filtering
$search = isset($_GET['search']) ? mysqli_real_escape_string($con, $_GET['search']) : '';
$status_filter = isset($_GET['status']) ? mysqli_real_escape_string($con, $_GET['status']) : '';
$type_filter = isset($_GET['type']) ? mysqli_real_escape_string($con, $_GET['type']) : '';

$query = "SELECT * FROM vehicles WHERE 1=1";

if (!empty($search)) {
    $query .= " AND (vehicle_number LIKE '%$search%' OR make LIKE '%$search%' OR model LIKE '%$search%' OR assigned_driver LIKE '%$search%')";
}

if (!empty($status_filter)) {
    $query .= " AND status='$status_filter'";
}

if (!empty($type_filter)) {
    $query .= " AND vehicle_type='$type_filter'";
}

$query .= " ORDER BY vehicle_number ASC";
$result = mysqli_query($con, $query);
?>
<!DOCTYPE html>
<html>
<head>
    <?php include 'includes/htmlhead.php'; ?>
    <title>Transportation Management - School Manager</title>
</head>
<body class="sticky-header">
<section>
    <?php include 'includes/header.php'; ?>
    
    <section class="wrapper">
        <section class="section">
            <div class="row">
                <div class="col-lg-12">
                    <section class="panel">
                        <header class="panel-heading">
                            <h4 class="panel-title"><i class="fa fa-bus"></i> Transportation Management - School Vehicles</h4>
                        </header>
                        
                        <div class="panel-body">
                            <?php if (isset($_SESSION['message'])): ?>
                                <div class="alert alert-success alert-dismissible">
                                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                                    <?php echo htmlspecialchars($_SESSION['message']); unset($_SESSION['message']); ?>
                                </div>
                            <?php endif; ?>
                            
                            <div class="row margin-bottom-10">
                                <div class="col-md-6">
                                    <a href="addvehicle.php" class="btn btn-primary btn-sm">
                                        <i class="fa fa-plus"></i> Add New Vehicle
                                    </a>
                                    <a href="busroutes.php" class="btn btn-info btn-sm">
                                        <i class="fa fa-map-signs"></i> Bus Routes
                                    </a>
                                </div>
                                <div class="col-md-6">
                                    <form method="GET" class="form-inline pull-right">
                                        <input type="text" name="search" class="form-control input-sm" placeholder="Search vehicle..." value="<?php echo htmlspecialchars($search); ?>">
                                        <select name="type" class="form-control input-sm">
                                            <option value="">All Types</option>
                                            <option value="Bus" <?php echo $type_filter === 'Bus' ? 'selected' : ''; ?>>Bus</option>
                                            <option value="Van" <?php echo $type_filter === 'Van' ? 'selected' : ''; ?>>Van</option>
                                            <option value="Car" <?php echo $type_filter === 'Car' ? 'selected' : ''; ?>>Car</option>
                                            <option value="Truck" <?php echo $type_filter === 'Truck' ? 'selected' : ''; ?>>Truck</option>
                                        </select>
                                        <select name="status" class="form-control input-sm">
                                            <option value="">All Status</option>
                                            <option value="Active" <?php echo $status_filter === 'Active' ? 'selected' : ''; ?>>Active</option>
                                            <option value="In Maintenance" <?php echo $status_filter === 'In Maintenance' ? 'selected' : ''; ?>>In Maintenance</option>
                                            <option value="Out of Service" <?php echo $status_filter === 'Out of Service' ? 'selected' : ''; ?>>Out of Service</option>
                                            <option value="Retired" <?php echo $status_filter === 'Retired' ? 'selected' : ''; ?>>Retired</option>
                                        </select>
                                        <button type="submit" class="btn btn-primary btn-sm"><i class="fa fa-search"></i> Filter</button>
                                        <a href="vehicles.php" class="btn btn-default btn-sm">Clear</a>
                                    </form>
                                </div>
                            </div>
                            
                            <div class="table-responsive">
                                <table class="table table-striped table-hover" id="vehiclesTable">
                                    <thead>
                                        <tr>
                                            <th>Vehicle #</th>
                                            <th>Type</th>
                                            <th>Make/Model</th>
                                            <th>Year</th>
                                            <th>Capacity</th>
                                            <th>Driver</th>
                                            <th>Status</th>
                                            <th>Insurance Expiry</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if ($result && mysqli_num_rows($result) > 0): ?>
                                            <?php while ($row = mysqli_fetch_assoc($result)): ?>
                                                <?php
                                                $status_class = 'default';
                                                if ($row['status'] === 'Active') $status_class = 'success';
                                                elseif ($row['status'] === 'In Maintenance') $status_class = 'warning';
                                                elseif ($row['status'] === 'Out of Service') $status_class = 'danger';
                                                
                                                // Check insurance expiry
                                                $insurance_alert = '';
                                                if (!empty($row['insurance_expiry'])) {
                                                    $expiry_date = strtotime($row['insurance_expiry']);
                                                    $days_left = floor(($expiry_date - time()) / 86400);
                                                    if ($days_left < 0) {
                                                        $insurance_alert = '<span class="label label-danger">Expired</span>';
                                                    } elseif ($days_left < 30) {
                                                        $insurance_alert = '<span class="label label-warning">Expiring Soon</span>';
                                                    }
                                                }
                                                ?>
                                                <tr>
                                                    <td><strong><?php echo htmlspecialchars($row['vehicle_number']); ?></strong></td>
                                                    <td><?php echo htmlspecialchars($row['vehicle_type']); ?></td>
                                                    <td><?php echo htmlspecialchars($row['make'] . ' ' . $row['model']); ?></td>
                                                    <td><?php echo htmlspecialchars($row['year'] ?? 'N/A'); ?></td>
                                                    <td><?php echo htmlspecialchars($row['capacity'] ?? 'N/A'); ?></td>
                                                    <td><?php echo htmlspecialchars($row['assigned_driver'] ?? 'Not Assigned'); ?></td>
                                                    <td><span class="label label-<?php echo $status_class; ?>"><?php echo htmlspecialchars($row['status']); ?></span></td>
                                                    <td>
                                                        <?php echo !empty($row['insurance_expiry']) ? date('M d, Y', strtotime($row['insurance_expiry'])) : 'N/A'; ?>
                                                        <?php echo $insurance_alert; ?>
                                                    </td>
                                                    <td>
                                                        <a href="editvehicle.php?id=<?php echo $row['vehicle_id']; ?>" class="btn btn-info btn-xs">
                                                            <i class="fa fa-edit"></i> Edit
                                                        </a>
                                                        <a href="vehiclemaintenance.php?vehicle_id=<?php echo $row['vehicle_id']; ?>" class="btn btn-success btn-xs">
                                                            <i class="fa fa-wrench"></i> Maintenance
                                                        </a>
                                                    </td>
                                                </tr>
                                            <?php endwhile; ?>
                                        <?php else: ?>
                                            <tr><td colspan="9" class="text-center">No vehicles found. <a href="addvehicle.php">Add a vehicle</a></td></tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </section>
                </div>
            </div>
        </section>
    </section>
</section>
    
    <?php include 'includes/footer.php'; ?>
    <script src="js/jquery.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script class="include" type="text/javascript" src="js/jquery.dcjqaccordion.2.7.js"></script>
    <script src="js/jquery.scrollTo.min.js"></script>
    <script src="js/jQuery-slimScroll-1.3.0/jquery.slimscroll.js"></script>
    <script src="js/jquery.nicescroll.js"></script>
    <script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
    <script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
    
    <script>
    $(document).ready(function() {
        $('#vehiclesTable').DataTable({
            "pageLength": 25
        });
    });
    </script>
</body>
</html>
