<?php
session_start();
include 'includes/conn.php';
include 'includes/roles.php';

$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
if (!hasFinancialAccess($user_level) && $user_level !== 2) {
    header('Location: index.php');
    exit;
}

$vehicle_id = isset($_GET['id']) ? (int) $_GET['id'] : 0;
if ($vehicle_id <= 0) {
    header('Location: vehicles.php');
    exit;
}

$stmt = mysqli_prepare($con, "SELECT * FROM vehicles WHERE vehicle_id = ? LIMIT 1");
mysqli_stmt_bind_param($stmt, 'i', $vehicle_id);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$vehicle = mysqli_fetch_assoc($result);

if (!$vehicle) {
    $_SESSION['error'] = 'Vehicle not found';
    header('Location: vehicles.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $maintenance_type = mysqli_real_escape_string($con, $_POST['maintenance_type'] ?? 'Regular Service');
    $maintenance_date = mysqli_real_escape_string($con, $_POST['maintenance_date'] ?? date('Y-m-d'));
    $mileage_at_maintenance = !empty($_POST['mileage_at_maintenance']) ? (int) $_POST['mileage_at_maintenance'] : 0;
    $description = mysqli_real_escape_string($con, $_POST['description'] ?? '');
    $service_provider = mysqli_real_escape_string($con, $_POST['service_provider'] ?? '');
    $cost = !empty($_POST['cost']) ? (float) $_POST['cost'] : 0;
    $invoice_number = mysqli_real_escape_string($con, $_POST['invoice_number'] ?? '');
    $parts_replaced = mysqli_real_escape_string($con, $_POST['parts_replaced'] ?? '');
    $next_service_due = !empty($_POST['next_service_due']) ? "'" . mysqli_real_escape_string($con, $_POST['next_service_due']) . "'" : 'NULL';
    $notes = mysqli_real_escape_string($con, $_POST['notes'] ?? '');
    
    $insert = "INSERT INTO vehicle_maintenance (vehicle_id, maintenance_type, maintenance_date, mileage_at_maintenance, 
               description, service_provider, cost, invoice_number, parts_replaced, next_service_due, notes, recorded_by) 
               VALUES ($vehicle_id, '$maintenance_type', '$maintenance_date', $mileage_at_maintenance, '$description', 
               '$service_provider', $cost, '$invoice_number', '$parts_replaced', $next_service_due, '$notes', 
               '" . ($_SESSION['school_staff_name'] ?? $_SESSION['secuser'] ?? 'System') . "')";
    
    if (mysqli_query($con, $insert)) {
        $update_vehicle = "UPDATE vehicles SET last_service_date='$maintenance_date', current_mileage=$mileage_at_maintenance";
        if ($next_service_due !== 'NULL') {
            $update_vehicle .= ", next_service_date=$next_service_due";
        }
        $update_vehicle .= " WHERE vehicle_id=$vehicle_id";
        mysqli_query($con, $update_vehicle);
        
        $_SESSION['message'] = 'Maintenance record added successfully';
        header('Location: vehiclemaintenance.php?id=' . $vehicle_id);
        exit;
    } else {
        $error = 'Error adding maintenance record: ' . mysqli_error($con);
    }
}

$stmt = mysqli_prepare($con, "SELECT * FROM vehicle_maintenance WHERE vehicle_id = ? ORDER BY maintenance_date DESC");
mysqli_stmt_bind_param($stmt, 'i', $vehicle_id);
mysqli_stmt_execute($stmt);
$maintenance_records = mysqli_stmt_get_result($stmt);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <meta name="description" content="">
    <meta name="author" content="ThemeBucket">
    <link rel="shortcut icon" href="#" type="image/png">
    <title>Vehicle Maintenance - School Manager</title>
    <link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
    <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
    <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
    <?php include 'includes/header.php'; ?>
    
    <section class="wrapper">
        <section class="section">
            <div class="row">
                <div class="col-lg-12">
                    <section class="panel">
                        <header class="panel-heading">
                            <h4 class="panel-title">
                                <i class="fa fa-wrench"></i> Maintenance History: <?php echo htmlspecialchars($vehicle['vehicle_number']); ?>
                                <span class="pull-right">
                                    <a href="vehicles.php" class="btn btn-sm btn-default"><i class="fa fa-arrow-left"></i> Back</a>
                                    <button class="btn btn-sm btn-primary" data-toggle="modal" data-target="#addMaintenanceModal"><i class="fa fa-plus"></i> Add Maintenance</button>
                                </span>
                            </h4>
                        </header>
                        
                        <div class="panel-body">
                            <?php if (isset($_SESSION['message'])): ?>
                                <div class="alert alert-success"><?php echo htmlspecialchars($_SESSION['message']); unset($_SESSION['message']); ?></div>
                            <?php endif; ?>
                            <?php if (isset($error)): ?>
                                <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
                            <?php endif; ?>
                            
                            <div class="row" style="margin-bottom:20px;">
                                <div class="col-md-3">
                                    <div class="panel panel-default">
                                        <div class="panel-body text-center">
                                            <h5><strong>Vehicle Type</strong></h5>
                                            <p><?php echo htmlspecialchars($vehicle['vehicle_type']); ?></p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="panel panel-default">
                                        <div class="panel-body text-center">
                                            <h5><strong>Make/Model</strong></h5>
                                            <p><?php echo htmlspecialchars($vehicle['make'] . ' ' . $vehicle['model']); ?></p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="panel panel-default">
                                        <div class="panel-body text-center">
                                            <h5><strong>Current Mileage</strong></h5>
                                            <p><?php echo number_format($vehicle['current_mileage']); ?> km</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="panel panel-default">
                                        <div class="panel-body text-center">
                                            <h5><strong>Last Service</strong></h5>
                                            <p><?php echo $vehicle['last_service_date'] ? date('d M Y', strtotime($vehicle['last_service_date'])) : 'N/A'; ?></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <table id="maintenanceTable" class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Type</th>
                                        <th>Mileage</th>
                                        <th>Description</th>
                                        <th>Service Provider</th>
                                        <th>Cost (KES)</th>
                                        <th>Next Service</th>
                                        <th>Recorded By</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php while ($record = mysqli_fetch_assoc($maintenance_records)): ?>
                                    <tr>
                                        <td><?php echo date('d M Y', strtotime($record['maintenance_date'])); ?></td>
                                        <td><span class="label label-<?php 
                                            echo $record['maintenance_type'] === 'Emergency Repair' ? 'danger' : 
                                                ($record['maintenance_type'] === 'Regular Service' ? 'success' : 'info'); 
                                        ?>"><?php echo htmlspecialchars($record['maintenance_type']); ?></span></td>
                                        <td><?php echo number_format($record['mileage_at_maintenance']); ?> km</td>
                                        <td><?php echo htmlspecialchars($record['description']); ?></td>
                                        <td><?php echo htmlspecialchars($record['service_provider'] ?? 'N/A'); ?></td>
                                        <td><?php echo number_format($record['cost'], 2); ?></td>
                                        <td><?php echo $record['next_service_due'] ? date('d M Y', strtotime($record['next_service_due'])) : 'N/A'; ?></td>
                                        <td><?php echo htmlspecialchars($record['recorded_by']); ?></td>
                                    </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    </section>
                </div>
            </div>
        </section>
    </section>
    
    <!-- Add Maintenance Modal -->
    <div class="modal fade" id="addMaintenanceModal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Add Maintenance Record</h4>
                </div>
                <form method="POST">
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Maintenance Type *</label>
                                    <select name="maintenance_type" class="form-control" required>
                                        <option value="Regular Service">Regular Service</option>
                                        <option value="Oil Change">Oil Change</option>
                                        <option value="Tire Replacement">Tire Replacement</option>
                                        <option value="Brake Service">Brake Service</option>
                                        <option value="Battery Replacement">Battery Replacement</option>
                                        <option value="Engine Repair">Engine Repair</option>
                                        <option value="Transmission Repair">Transmission Repair</option>
                                        <option value="Emergency Repair">Emergency Repair</option>
                                        <option value="Inspection">Inspection</option>
                                        <option value="Other">Other</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label>Maintenance Date *</label>
                                    <input type="date" name="maintenance_date" class="form-control" value="<?php echo date('Y-m-d'); ?>" required>
                                </div>
                                <div class="form-group">
                                    <label>Mileage at Maintenance (km) *</label>
                                    <input type="number" name="mileage_at_maintenance" class="form-control" min="0" value="<?php echo $vehicle['current_mileage']; ?>" required>
                                </div>
                                <div class="form-group">
                                    <label>Description *</label>
                                    <textarea name="description" class="form-control" rows="3" required></textarea>
                                </div>
                                <div class="form-group">
                                    <label>Service Provider</label>
                                    <input type="text" name="service_provider" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Cost (KES) *</label>
                                    <input type="number" name="cost" class="form-control" step="0.01" min="0" required>
                                </div>
                                <div class="form-group">
                                    <label>Invoice Number</label>
                                    <input type="text" name="invoice_number" class="form-control">
                                </div>
                                <div class="form-group">
                                    <label>Parts Replaced</label>
                                    <textarea name="parts_replaced" class="form-control" rows="2" placeholder="List parts replaced..."></textarea>
                                </div>
                                <div class="form-group">
                                    <label>Next Service Due</label>
                                    <input type="date" name="next_service_due" class="form-control">
                                </div>
                                <div class="form-group">
                                    <label>Notes</label>
                                    <textarea name="notes" class="form-control" rows="3"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Save Maintenance</button>
                    </div>
                </form>
            </div>
        </div>
    </section>
</section>
    
    <?php include 'includes/footer.php'; ?>
    <script src="js/jquery.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script class="include" type="text/javascript" src="js/jquery.dcjqaccordion.2.7.js"></script>
    <script src="js/jquery.scrollTo.min.js"></script>
    <script src="js/jQuery-slimScroll-1.3.0/jquery.slimscroll.js"></script>
    <script src="js/jquery.nicescroll.js"></script>
    <script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
    <script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
    <script>
        $(document).ready(function() {
            $('#maintenanceTable').DataTable({
                order: [[0, 'desc']]
            });
        });
    </script>
</body>
</html>
