<?php
include 'includes/conn.php';
include 'includes/roles.php'; // Include centralized role management
// allow access when either admin session namespace indicates Super Admin
$isSuperAdmin = (($_SESSION['secusyslevel'] ?? 0) == 1) || (($_SESSION['schoolsyslevel'] ?? 0) == 1);
if (!$isSuperAdmin) {
  header('Location: login');
  exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>Users</title>
<link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />

  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">

</head>

<body class="sticky-header">
<section>
   <?php include 'includes/header.php'; ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
    <div class="col-lg-12">
                      <section class="panel">
                    <header class="panel-heading">
                     Users Management
                    </header>
                          <div class="panel-body">
<?php
if (!empty($_SESSION['msg'])) {
    echo '<div class="alert alert-info">' . htmlspecialchars($_SESSION['msg'], ENT_QUOTES) . '</div>';
    unset($_SESSION['msg']);
}
?>
              <table  class="display table  table-striped" id="dynamic-table">
        <thead>
        <tr>
            <th>No.</th>
            <th>Staff</th>
            <th>Email</th>
      <th>Role</th>
      <th>Status</th>
      <th>Actions</th>
        </tr>
        </thead>
        <tbody>
<?php
// load all users (both active and inactive) - includes non-teaching staff
$getusers = mysqli_query($con, "SELECT * FROM users");
$users_data = [];
if ($getusers) {
  while ($row = mysqli_fetch_assoc($getusers)) {
    $user_id = $row['user_id'];
    $staff_id = $row['staff_id'];
    $level = $row['level'];
    $status = isset($row['status']) ? (int)$row['status'] : 0;
    $getstaff = mysqli_query($con, "SELECT * FROM staff WHERE staff_id='" . (int)$staff_id . "'");
    $s = $getstaff ? mysqli_fetch_assoc($getstaff) : null;
    $staff_name = $s['fullname'] ?? 'N/A';
    $email = $s['email'] ?? '';
    
    $users_data[] = [
      'user_id' => $user_id,
      'staff_id' => $staff_id,
      'name' => $staff_name,
      'email' => $email,
      'level' => $level,
      'status' => $status,
      'type' => 'staff'
    ];
  }
}

// Also load all teachers
$getteachers = mysqli_query($con, "SELECT teacher_id, fullname, email, status, classteacher FROM teachers WHERE status IN (0,1)");
if ($getteachers) {
  while ($row = mysqli_fetch_assoc($getteachers)) {
    $is_class_teacher = ($row['classteacher'] ?? 'no') === 'yes';
    $users_data[] = [
      'user_id' => 'T-' . $row['teacher_id'],
      'staff_id' => $row['teacher_id'],
      'name' => $row['fullname'] ?? 'N/A',
      'email' => $row['email'] ?? '',
      'level' => 0, // Teachers don't have admin levels
      'status' => (int)$row['status'],
      'type' => 'teacher',
      'is_class_teacher' => $is_class_teacher
    ];
  }
}

// Display all users
$counter = 1;
foreach ($users_data as $user) {
    if ($user['type'] === 'teacher') {
      $role = ($user['is_class_teacher'] ?? false) ? 'Class Teacher' : 'Teacher';
    } else {
      $role = getRoleName($user['level']);
    }
    ?>
    <tr>
        <td><?php echo $counter++; ?></td>
        <td><?php echo htmlspecialchars($user['name']); ?></td>
        <td><?php echo htmlspecialchars($user['email']); ?></td>
    <td><?php echo htmlspecialchars($role); ?></td>
    <td>
      <?php if ($user['status'] === 1): ?>
        <span class="label label-success">Active</span>
      <?php else: ?>
        <span class="label label-default">Inactive</span>
      <?php endif; ?>
    </td>
    <td>
      <?php if ($user['type'] === 'teacher'): ?>
        <a href="teacher?id=<?php echo (int)$user['staff_id']; ?>" class="btn btn-info btn-xs">Details</a>
        <a href="edit_teacher.php?id=<?php echo (int)$user['staff_id']; ?>" class="btn btn-primary btn-xs">Edit</a>
        <a href="" class="btn btn-warning btn-xs" data-toggle="modal" data-target="#modal-pass-T-<?php echo (int)$user['staff_id']; ?>">Change Password</a>
      <?php else: ?>
        <a href="staff?id=<?php echo (int)$user['staff_id']; ?>" class="btn btn-info btn-xs">Details</a>
        <a href="edituser.php?id=<?php echo (int)str_replace('T-', '', $user['user_id']); ?>" class="btn btn-primary btn-xs">Edit</a>
        <a href="" class="btn btn-warning btn-xs" data-toggle="modal" data-target="#modal-pass-<?php echo htmlspecialchars($user['user_id']); ?>">Change Password</a>
      <?php endif; ?>
    </td>
    </tr>
    <?php if ($user['type'] === 'teacher'): ?>
    <!-- Password modal for teacher -->
    <div class="modal fade" id="modal-pass-T-<?php echo (int)$user['staff_id']; ?>" tabindex="-1" role="dialog" aria-hidden="true">
      <div class="modal-dialog">
        <div class="modal-content">
          <div class="modal-body">
            <h4>Change Password for <?php echo htmlspecialchars($user['name']); ?></h4>
            <form action="teacher_change_password.php" method="post">
              <div class="form-group">
                <label>New Password</label>
                <input type="password" name="newpass" class="form-control" required>
              </div>
              <div class="form-group">
                <label>Confirm Password</label>
                <input type="password" name="newpass2" class="form-control" required>
              </div>
              <input type="hidden" name="teacher_id" value="<?php echo (int)$user['staff_id']; ?>">
              <button class="btn btn-primary" type="submit">Update Password</button>
            </form>
          </div>
        </div>
      </div>
    </div>
    <?php else: ?>
    <!-- Password modal for staff -->
    <div class="modal fade" id="modal-pass-<?php echo htmlspecialchars($user['user_id']); ?>" tabindex="-1" role="dialog" aria-hidden="true">
      <div class="modal-dialog">
        <div class="modal-content">
          <div class="modal-body">
            <h4>Change Password for <?php echo htmlspecialchars($user['name']); ?></h4>
            <form action="admin_change_password.php" method="post">
              <div class="form-group">
                <label>New Password</label>
                <input type="password" name="newpass" class="form-control" required>
              </div>
              <div class="form-group">
                <label>Confirm Password</label>
                <input type="password" name="newpass2" class="form-control" required>
              </div>
              <input type="hidden" name="user_id" value="<?php echo (int)$user['user_id']; ?>">
              <button class="btn btn-primary" type="submit">Update Password</button>
            </form>
          </div>
        </div>
      </div>
    </div>
    <?php endif; ?>
    <?php
}
?>
        </tbody>
                        </table>
                          </div>
                          </div>

        </div>
        </div>
        </section>
</section>
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script type="text/javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
<script src="js/scripts.js"></script>
<script type="text/javascript">
  $(document).ready(function() {
    $('#dynamic-table').dataTable({
      "aaSorting": [[0, "desc"]],
      "aLengthMenu": [[10, 25, 50, -1], [10, 25, 50, "All"]],
      "iDisplayLength": 25
    });
  });
</script>
</body>
</html>
