<?php
include 'includes/conn.php';
include 'includes/roles.php';
if (session_status() === PHP_SESSION_NONE) { session_start(); }
// Normalize session role level: support both legacy `secusyslevel` and `schoolsyslevel`
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
if (!hasFinancialAccess($user_level)) { header('Location:login.php'); exit; }

$accountId = isset($_GET['id']) ? (int)$_GET['id'] : 0;

$neededTables = ['bank_accounts','bank_transactions'];
foreach ($neededTables as $tbl) {
    $check = mysqli_query($con, "SHOW TABLES LIKE '$tbl'");
    if (!$check || mysqli_num_rows($check) === 0) {
        die("$tbl table not found. Run create_accounting_tables.sql");
    }
}

if ($accountId <= 0) {
    header('Location: bankaccounts.php');
    exit;
}

$accountRes = mysqli_query($con, "SELECT * FROM bank_accounts WHERE bank_account_id=$accountId LIMIT 1");
$account = mysqli_fetch_assoc($accountRes);
if (!$account) { die('Bank account not found'); }

$txRes = mysqli_query($con, "SELECT * FROM bank_transactions WHERE bank_account_id=$accountId ORDER BY transaction_date DESC, transaction_time DESC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Transactions by Account</title>
  <link rel="stylesheet" href="css/style.css">
  <link rel="stylesheet" href="css/style-responsive.css">
  <link rel="stylesheet" href="assets/advanced-datatable/media/css/demo_page.css" />
  <link rel="stylesheet" href="assets/advanced-datatable/media/css/demo_table.css" />
  <link rel="stylesheet" href="assets/data-tables/DT_bootstrap.css" />
</head>
<body class="sticky-header">
<section>
  <?php include 'includes/header.php'; ?>
  <section class="wrapper">
    <div class="row">
      <div class="col-lg-12">
        <section class="panel">
          <header class="panel-heading">
            <h3><i class="fa fa-exchange"></i> Transactions for <?php echo htmlspecialchars($account['bank_name'].' - '.$account['account_number']); ?></h3>
            <div style="margin-top:10px;">
              <a href="bankaccounts.php" class="btn btn-default btn-sm">Back</a>
              <a href="addbanktransaction.php?account_id=<?php echo $accountId; ?>" class="btn btn-primary btn-sm">Add Transaction</a>
            </div>
          </header>
          <div class="panel-body">
            <div class="adv-table">
              <table class="display table table-bordered table-striped" id="dynamic-table">
                <thead>
                  <tr>
                    <th>Date</th>
                    <th>Time</th>
                    <th>Type</th>
                    <th>Amount</th>
                    <th>Reference</th>
                    <th>Description</th>
                    <th>Status</th>
                  </tr>
                </thead>
                <tbody>
                  <?php while ($tx = mysqli_fetch_assoc($txRes)) { ?>
                  <tr>
                    <td><?php echo htmlspecialchars($tx['transaction_date']); ?></td>
                    <td><?php echo htmlspecialchars($tx['transaction_time']); ?></td>
                    <td><?php echo htmlspecialchars($tx['transaction_type']); ?></td>
                    <td><?php echo number_format((float)$tx['amount'], 2); ?></td>
                    <td><?php echo htmlspecialchars($tx['reference_number']); ?></td>
                    <td><?php echo htmlspecialchars($tx['description']); ?></td>
                    <td><?php
                      $rawStatus = $tx['status'];
                      // If status is stored as numeric (legacy), keep Posted/Draft behavior
                      if (is_numeric($rawStatus)) {
                        echo ((int)$rawStatus === 1 ? 'Posted' : 'Draft');
                      } else {
                        // Otherwise show the status string from DB (e.g. Pending, Completed, Reconciled)
                        echo htmlspecialchars($rawStatus);
                      }
                    ?></td>
                  </tr>
                  <?php } ?>
                </tbody>
              </table>
            </div>
          </div>
        </section>
      </div>
    </div>
  </section>
</section>
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script type="text/javascript" language="javascript" src="assets/advanced-datatable/media/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="assets/data-tables/DT_bootstrap.js"></script>
<script src="js/dynamic_table_init.js"></script>
</body>
</html>