<?php
include 'includes/conn.php';
include 'includes/roles.php';
include 'includes/financial_logging.php';

// Normalize user level (support legacy keys)
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);

// Allow Super Admin (1) and Finance/Admin (3) and Finance Manager (8)
$allowed_roles = [1,3,8];
if (!in_array($user_level, $allowed_roles)) {
    header('Location: login.php');
    exit();
}

// Export CSV if requested
if (isset($_GET['export']) && $_GET['export'] == '1') {
    $start = $_GET['start_date'] ?? date('Y-m-01');
    $end = $_GET['end_date'] ?? date('Y-m-d');
    exportTransactionLogsToCSV($con, $start, $end, 'transaction_logs_' . date('Ymd') . '.csv');
    exit();
}

// Check table existence
$tbl_check = mysqli_query($con, "SHOW TABLES LIKE 'transaction_logs'");
$tbl_exists = ($tbl_check && mysqli_num_rows($tbl_check) > 0);

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Transaction Logs</title>
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
    <?php include 'includes/header.php'; ?>
    <section class="wrapper">
        <div class="row">
            <div class="col-lg-12">
                <section class="panel">
                    <header class="panel-heading">
                        <h4 class="panel-title"><i class="fa fa-file"></i> Transaction Logs</h4>
                    </header>
                    <div class="panel-body">
                        <?php if (isset($_SESSION['message'])) {
                            echo '<div class="alert alert-' . (isset($_SESSION['msg_type']) ? $_SESSION['msg_type'] : 'info') . ' alert-dismissible"><button type="button" class="close" data-dismiss="alert">&times;</button>' . htmlspecialchars($_SESSION['message']) . '</div>';
                            unset($_SESSION['message']); unset($_SESSION['msg_type']);
                        } ?>

                        <?php if (!$tbl_exists): ?>
                            <div class="alert alert-warning">
                                <strong>Notice:</strong> The `transaction_logs` table does not exist in this database.
                                Please run the SQL migration `sql/create_accounting_tables.sql` or create the table manually.
                            </div>
                        <?php else: ?>

                        <form class="form-inline" method="GET" action="transactionlogs.php">
                            <div class="form-group">
                                <label>Start:</label>
                                <input type="date" name="start_date" class="form-control" value="<?php echo htmlspecialchars($_GET['start_date'] ?? date('Y-m-01')); ?>">
                            </div>
                            <div class="form-group">
                                <label>End:</label>
                                <input type="date" name="end_date" class="form-control" value="<?php echo htmlspecialchars($_GET['end_date'] ?? date('Y-m-d')); ?>">
                            </div>
                            <div class="form-group">
                                <button class="btn btn-primary" type="submit">Filter</button>
                            </div>
                            <div class="form-group" style="margin-left:10px;">
                                <a class="btn btn-default" href="transactionlogs.php?export=1&start_date=<?php echo urlencode($_GET['start_date'] ?? date('Y-m-01')); ?>&end_date=<?php echo urlencode($_GET['end_date'] ?? date('Y-m-d')); ?>">Export CSV</a>
                            </div>
                        </form>

                        <hr />

                        <?php
                        $start = mysqli_real_escape_string($con, $_GET['start_date'] ?? date('Y-m-01'));
                        $end = mysqli_real_escape_string($con, $_GET['end_date'] ?? date('Y-m-d'));

                        $query = "SELECT * FROM transaction_logs WHERE DATE(log_date) >= '$start' AND DATE(log_date) <= '$end' ORDER BY log_date DESC LIMIT 1000";
                        $res = mysqli_query($con, $query);
                        if ($res && mysqli_num_rows($res) > 0) {
                            echo '<div class="table-responsive"><table class="table table-striped table-bordered">';
                            echo '<thead><tr><th>Log ID</th><th>Date</th><th>Type</th><th>Module</th><th>Related ID</th><th>User</th><th>Action</th><th>Amount</th><th>Description</th><th>IP</th></tr></thead><tbody>';
                            while ($row = mysqli_fetch_assoc($res)) {
                                echo '<tr>';
                                echo '<td>' . htmlspecialchars($row['log_id']) . '</td>';
                                echo '<td>' . htmlspecialchars($row['log_date']) . '</td>';
                                echo '<td>' . htmlspecialchars($row['transaction_type']) . '</td>';
                                echo '<td>' . htmlspecialchars($row['related_module']) . '</td>';
                                echo '<td>' . htmlspecialchars($row['related_id']) . '</td>';
                                echo '<td>' . htmlspecialchars($row['username']) . '</td>';
                                echo '<td>' . htmlspecialchars($row['action']) . '</td>';
                                echo '<td>' . htmlspecialchars($row['amount']) . '</td>';
                                echo '<td>' . htmlspecialchars($row['description']) . '</td>';
                                echo '<td>' . htmlspecialchars($row['ip_address']) . '</td>';
                                echo '</tr>';
                            }
                            echo '</tbody></table></div>';
                        } else {
                            echo '<div class="alert alert-info">No transaction logs found for the selected range.</div>';
                        }
                        ?>

                        <?php endif; // table exists ?>
                    </div>
                </section>
            </div>
        </div>
    </section>
</section>

<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
</body>
</html>
