<?php
/**
 * Helper to change the financial term (year) for a weekly plan row.
 * Usage:
 *  - View: /tools/set_weekly_term.php?id=10
 *  - Update: /tools/set_weekly_term.php?id=10&term_id=3&do=1
 */
require __DIR__ . '/../includes/conn.php';
if (session_status() === PHP_SESSION_NONE) session_start();

header('Content-Type: text/html; charset=utf-8');
echo '<h2>Set Weekly Plan Year/Term</h2>';
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) {
  echo '<p style="color:red">Please provide ?id=&lt;weeklyplan_id&gt; in the URL.</p>';
  exit;
}

// show current row
$stmt = mysqli_prepare($con, 'SELECT weeklyplan_id, class_sub_id, teacher_id, startdate, enddate, year, term, weeklyplandoc, timestamp FROM weeklyplans WHERE weeklyplan_id = ? LIMIT 1');
mysqli_stmt_bind_param($stmt, 'i', $id);
mysqli_stmt_execute($stmt);
$res = mysqli_stmt_get_result($stmt);
$row = mysqli_fetch_assoc($res);
mysqli_stmt_close($stmt);

echo '<h3>Plan row</h3>';
echo '<pre>' . htmlspecialchars(print_r($row, true)) . '</pre>';

// show financial terms
echo '<h3>Available Financial Terms (select desired year)</h3>';
$termsRes = mysqli_query($con, "SELECT financialterm_id, term, year FROM financialterms WHERE status = 1 ORDER BY year DESC, financialterm_id DESC");
if (!$termsRes) {
  echo '<p style="color:red">Could not fetch financial terms: ' . htmlspecialchars(mysqli_error($con)) . '</p>';
  exit;
}
echo '<ul>';
while ($t = mysqli_fetch_assoc($termsRes)) {
  $tid = (int)$t['financialterm_id'];
  $label = 'Term ' . ($t['term'] ?? '') . ' ' . ($t['year'] ?? '');
  $selLink = '?id=' . $id . '&term_id=' . $tid . '&do=1';
  echo '<li>' . htmlspecialchars($label) . ' — <a href="' . htmlspecialchars($selLink) . '">Select</a></li>';
}
echo '</ul>';

$term_id = filter_input(INPUT_GET, 'term_id', FILTER_VALIDATE_INT);
$do = filter_input(INPUT_GET, 'do', FILTER_VALIDATE_INT);
if ($do === 1 && $term_id) {
  // backup row (print)
  echo '<h3>Before update</h3>';
  echo '<pre>' . htmlspecialchars(print_r($row, true)) . '</pre>';

  // update term and set year from financialterms for convenience
  $ftStmt = mysqli_prepare($con, 'SELECT year FROM financialterms WHERE financialterm_id = ? LIMIT 1');
  $ft_year = null;
  if ($ftStmt) {
    mysqli_stmt_bind_param($ftStmt, 'i', $term_id);
    mysqli_stmt_execute($ftStmt);
    $fres = mysqli_stmt_get_result($ftStmt);
    if ($fres && mysqli_num_rows($fres) > 0) {
      $ftrow = mysqli_fetch_assoc($fres);
      $ft_year = $ftrow['year'] ?? null;
    }
    mysqli_stmt_close($ftStmt);
  }

  if ($ft_year === null) {
    echo '<p style="color:red">Could not determine year for selected financial term.</p>';
  }

  $up = mysqli_prepare($con, 'UPDATE weeklyplans SET term = ?, year = ? WHERE weeklyplan_id = ? LIMIT 1');
  mysqli_stmt_bind_param($up, 'isi', $term_id, $ft_year, $id);
  $ok = mysqli_stmt_execute($up);
  $err = mysqli_stmt_error($up);
  mysqli_stmt_close($up);
  echo '<p>Update ' . ($ok ? '<strong style="color:green">succeeded</strong>' : '<strong style="color:red">failed</strong>') . '</p>';

  // show after
  $stmt2 = mysqli_prepare($con, 'SELECT * FROM weeklyplans WHERE weeklyplan_id = ? LIMIT 1');
  mysqli_stmt_bind_param($stmt2, 'i', $id);
  mysqli_stmt_execute($stmt2);
  $res2 = mysqli_stmt_get_result($stmt2);
  $row2 = mysqli_fetch_assoc($res2);
  mysqli_stmt_close($stmt2);
  echo '<h3>After update</h3>';
  echo '<pre>' . htmlspecialchars(print_r($row2, true)) . '</pre>';
}

echo '<p><a href="/">Back to app</a></p>';

?>
