<?php
/**
 * Safe helper to inspect and optionally update midterm_plans.file_path
 * Usage:
 *  - View row and files: /tools/fix_midterm_path.php?id=10
 *  - Update: /tools/fix_midterm_path.php?id=10&filename=1761076277_378e9a0cfbf4.pdf&do=1
 */
require __DIR__ . '/../includes/conn.php';
if (session_status() === PHP_SESSION_NONE) {
  session_start();
}

header('Content-Type: text/html; charset=utf-8');
echo '<h2>Midterm plan fixer</h2>';
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) {
  echo '<p style="color:red">Please provide ?id=&lt;midterm_plan_id&gt; in the URL.</p>';
  exit;
}

echo '<p>Target midterm_plan_id: <strong>' . htmlspecialchars($id) . '</strong></p>';

// show current DB row
$stmt = mysqli_prepare($con, 'SELECT * FROM midterm_plans WHERE midterm_plan_id = ? LIMIT 1');
mysqli_stmt_bind_param($stmt, 'i', $id);
mysqli_stmt_execute($stmt);
$res = mysqli_stmt_get_result($stmt);
$row = mysqli_fetch_assoc($res);
mysqli_stmt_close($stmt);

echo '<h3>DB row (before)</h3>';
echo '<pre>' . htmlspecialchars(print_r($row, true)) . '</pre>';

// list upload files
$uploadDir = __DIR__ . '/../uploads/midterm_plans/';
echo '<h3>Files in uploads/midterm_plans</h3>';
if (is_dir($uploadDir) && is_readable($uploadDir)) {
  $files = array_values(array_filter(scandir($uploadDir), function($f) use ($uploadDir) {
    return !in_array($f, ['.', '..']) && is_file($uploadDir . $f);
  }));
  if (count($files) === 0) {
    echo '<p>No files found.</p>';
  } else {
    echo '<ul>';
    foreach ($files as $f) {
      echo '<li>' . htmlspecialchars($f) . ' — <a href="?id=' . $id . '&amp;filename=' . urlencode($f) . '">Select</a></li>';
    }
    echo '</ul>';
  }
} else {
  echo '<p style="color:orange">Upload folder missing or not readable: ' . htmlspecialchars($uploadDir) . '</p>';
}

$filename = filter_input(INPUT_GET, 'filename', FILTER_SANITIZE_STRING);
$do = filter_input(INPUT_GET, 'do', FILTER_VALIDATE_INT);
if ($filename) {
  echo '<h3>Selected filename</h3>';
  echo '<p>' . htmlspecialchars($filename) . '</p>';
  $proposed = 'uploads/midterm_plans/' . $filename;
  echo '<p>Proposed file_path value: <code>' . htmlspecialchars($proposed) . '</code></p>';
}

if ($do === 1 && $filename) {
  // perform update (prepared)
  $stmt2 = mysqli_prepare($con, 'UPDATE midterm_plans SET file_path = ? WHERE midterm_plan_id = ? LIMIT 1');
  mysqli_stmt_bind_param($stmt2, 'si', $proposed, $id);
  $ok = mysqli_stmt_execute($stmt2);
  mysqli_stmt_close($stmt2);
  echo '<h3>Update result</h3>';
  echo '<p>' . ($ok ? '<span style="color:green">Update succeeded</span>' : '<span style="color:red">Update failed</span>') . '</p>';

  // show row after
  $stmt3 = mysqli_prepare($con, 'SELECT * FROM midterm_plans WHERE midterm_plan_id = ? LIMIT 1');
  mysqli_stmt_bind_param($stmt3, 'i', $id);
  mysqli_stmt_execute($stmt3);
  $res3 = mysqli_stmt_get_result($stmt3);
  $row3 = mysqli_fetch_assoc($res3);
  mysqli_stmt_close($stmt3);
  echo '<h3>DB row (after)</h3>';
  echo '<pre>' . htmlspecialchars(print_r($row3, true)) . '</pre>';
}

echo '<p><a href="/">Back to app</a></p>';

?>
