<?php
$host='127.0.0.1'; $user='root'; $pass='root'; $db='kingschool';
$m = new mysqli($host,$user,$pass,$db);
if($m->connect_errno){ echo "CONNECT_ERR: ".$m->connect_error."\n"; exit(1); }
// Check table exists
$r = $m->query("SHOW TABLES LIKE 'streams'");
if(!$r || $r->num_rows==0){ echo "TABLE_MISSING: 'streams' table not found in $db\n"; exit(1); }
// Check column
$colq = $m->prepare("SELECT COUNT(*) FROM information_schema.COLUMNS WHERE TABLE_SCHEMA=? AND TABLE_NAME='streams' AND COLUMN_NAME='status'");
$colq->bind_param('s',$db);
$colq->execute();
$colq->bind_result($cnt);
$colq->fetch();
$colq->close();
if($cnt>0){ echo "ALREADY_EXISTS: column 'status' already exists on streams\n"; $m->close(); exit(0); }
// Run ALTER - add status after `stream` column if exists, otherwise append
$colExists = $m->query("SELECT COLUMN_NAME FROM information_schema.COLUMNS WHERE TABLE_SCHEMA='$db' AND TABLE_NAME='streams' AND COLUMN_NAME='stream'");
$after = ($colExists && $colExists->num_rows>0) ? " AFTER stream" : "";
$alter = "ALTER TABLE streams ADD COLUMN status INT(2) DEFAULT 1 $after";
if($m->query($alter)===TRUE){ echo "ALTER_OK: column 'status' added\n"; } else { echo "ALTER_ERR: ".$m->error."\n"; }
// Verify
$r2 = $m->query("SELECT COLUMN_NAME, COLUMN_TYPE, COLUMN_DEFAULT FROM information_schema.COLUMNS WHERE TABLE_SCHEMA='".$db."' AND TABLE_NAME='streams' AND COLUMN_NAME='status'");
if($r2 && $row = $r2->fetch_assoc()){
    echo "VERIFY: ".json_encode($row)."\n";
}
$m->close();
