<?php
$host='127.0.0.1'; $user='root'; $pass='root'; $db='kingschool';
$m = new mysqli($host,$user,$pass,$db);
if($m->connect_errno){ echo "CONNECT_ERR: ".$m->connect_error."\n"; exit(1); }
// Check students table exists
$r = $m->query("SHOW TABLES LIKE 'students'");
if(!$r || $r->num_rows==0){ echo "TABLE_MISSING: 'students' table not found in $db\n"; exit(1); }
// Check column
$colq = $m->prepare("SELECT COUNT(*) FROM information_schema.COLUMNS WHERE TABLE_SCHEMA=? AND TABLE_NAME='students' AND COLUMN_NAME='family_id'");
$colq->bind_param('s',$db);
$colq->execute();
$colq->bind_result($cnt);
$colq->fetch();
$colq->close();
if($cnt>0){ echo "ALREADY_EXISTS: column 'family_id' already exists on students\n"; $m->close(); exit(0); }
// Run ALTER
$alter = "ALTER TABLE students ADD COLUMN family_id INT(11) DEFAULT 0 AFTER stream_id";
if($m->query($alter)===TRUE){ echo "ALTER_OK: column 'family_id' added\n"; } else { echo "ALTER_ERR: ".$m->error."\n"; }
// Verify
$r2 = $m->query("SELECT COLUMN_NAME, COLUMN_TYPE, COLUMN_DEFAULT FROM information_schema.COLUMNS WHERE TABLE_SCHEMA='".$db."' AND TABLE_NAME='students' AND COLUMN_NAME='family_id'");
if($r2 && $row = $r2->fetch_assoc()){
    echo "VERIFY: ".json_encode($row)."\n";
}
$m->close();
