<?php
include 'includes/conn.php';
if (!isset($_SESSION['schoolsyslevel']) || (($_SESSION['schoolsyslevel'] != 1) && ($_SESSION['schoolsyslevel'] != 2))) {
  header('Location: login.php');
  exit;
}

$classRaw = isset($_GET['class']) ? trim($_GET['class']) : '';
if ($classRaw === '') {
  header('Location: classes.php');
  exit;
}
$split = explode('_', $classRaw);
$class_id = isset($split[0]) ? (int) $split[0] : 0;
$stream_id = isset($split[1]) ? (int) $split[1] : 0;

$className = '';
$getclass = mysqli_query($con, "SELECT * FROM classes WHERE class_id={$class_id}");
if ($getclass) {
  $row2 = mysqli_fetch_assoc($getclass);
  $className = $row2['class'] ?? '';
}
$stream = '';
$getstream = mysqli_query($con, "SELECT * FROM streams WHERE stream_id={$stream_id}");
if ($getstream) {
  $row = mysqli_fetch_assoc($getstream);
  $stream = $row['stream'] ?? '';
}
// Detect column names for start/end time to support different schemas (starttime vs start_time)
$timeCols = [];
$colRes = @mysqli_query($con, "SHOW COLUMNS FROM timetables");
if ($colRes) {
  while ($crow = mysqli_fetch_assoc($colRes)) {
    $timeCols[] = $crow['Field'];
  }
}
$startCol = in_array('starttime', $timeCols) ? 'starttime' : (in_array('start_time', $timeCols) ? 'start_time' : (in_array('start', $timeCols) ? 'start' : null));
$endCol = in_array('endtime', $timeCols) ? 'endtime' : (in_array('end_time', $timeCols) ? 'end_time' : (in_array('end', $timeCols) ? 'end' : null));
// If we couldn't detect columns, default to legacy names so code continues but we will avoid running unsafe queries later.
if ($startCol === null) $startCol = 'starttime';
if ($endCol === null) $endCol = 'endtime';
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title><?php echo htmlspecialchars($className . ' ' . $stream); ?> TimeTable</title>
  <link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />

  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
  <section>
    <?php include 'includes/header.php'; ?>

    <section class="wrapper">
      <!-- page start-->

      <div class="row">

        <div class="col-lg-12">
          <section class="panel">
            <header class="panel-heading">
              <?php echo htmlspecialchars($className . ' ' . $stream, ENT_QUOTES); ?> TimeTable
              <a href="printtimetable?class=<?php echo $class_id . '_' . $stream_id; ?>" class="btn  btn-info pull-right" target="_blank">Print</a>
            </header>
            <div class="panel-body">
              <?php
              // Get all unique time slots for this class (collect into array so we don't pass false to fetch functions)
              $time_slots = array();
              // Build safe query using detected time column names
              $ts_sql = sprintf("SELECT DISTINCT %s AS starttime, %s AS endtime FROM timetables WHERE class_id=%d AND stream_id=%d ORDER BY %s", $startCol, $endCol, $class_id, $stream_id, $startCol);
              $time_slots_query = @mysqli_query($con, $ts_sql);
              if ($time_slots_query) {
                while ($tsr = mysqli_fetch_assoc($time_slots_query)) {
                  $time_slots[] = $tsr;
                }
              }

              // Get all days (collect into array). If table is missing/empty, fall back to common weekdays.
              $days_query = mysqli_query($con, "SELECT * FROM days");
              $days = array();
              if ($days_query) {
                while ($day_row = mysqli_fetch_assoc($days_query)) {
                  $days[] = $day_row['short'] ?? '';
                }
              }
              if (empty($days)) {
                // Fallback default short names if `days` table is not present or empty
                $days = array('Mon','Tue','Wed','Thu','Fri','Sat','Sun');
              }
              ?>

              <?php
              // Permission helpers
              $is_admin = (isset($_SESSION['schoolsyslevel']) && (int)$_SESSION['schoolsyslevel'] === 1);
              $is_class_teacher = (isset($_SESSION['classteacher']) && $_SESSION['classteacher'] === 'yes');
              $teacher_class_id = isset($_SESSION['class_id']) ? (int)$_SESSION['class_id'] : 0;

              // Compute current week dates for each day (Monday=1, Sunday=7)
              $today = new DateTime();
              $current_day_of_week = (int)$today->format('N'); // 1=Mon, 7=Sun
              $week_dates = [];
              // Map short day names to ISO day numbers
              $day_map = ['Mon'=>1, 'Tue'=>2, 'Wed'=>3, 'Thu'=>4, 'Fri'=>5, 'Sat'=>6, 'Sun'=>7];
              foreach ($days as $day_short) {
                $day_num = $day_map[ucfirst($day_short)] ?? 1;
                $offset = $day_num - $current_day_of_week;
                $day_date = (clone $today)->modify("{$offset} days")->format('Y-m-d');
                $week_dates[$day_short] = $day_date;
              }
              ?>

              <div class="table-responsive">
                <table class="table table-bordered table-striped">
                  <thead>
                    <tr>
                      <th>Time</th>
                      <?php foreach ($days as $day): ?>
                        <th><?php echo strtoupper($day); ?></th>
                      <?php endforeach; ?>
                    </tr>
                  </thead>
                  <tbody>
                    <?php foreach ($time_slots as $time_slot): ?>
                      <tr>
                          <td><?php echo htmlspecialchars(($time_slot['starttime'] ?? '') . ' - ' . ($time_slot['endtime'] ?? '')); ?></td>
                          <?php foreach ($days as $day): ?>
                            <td>
                              <?php
                              $starttime = $time_slot['starttime'] ?? '';
                              $endtime = $time_slot['endtime'] ?? '';
                              // Build subject query using detected time column names (aliased to starttime/endtime)
                              $subject_sql = sprintf(
                                "SELECT t.*, cs.class_sub_id, s.subject FROM `timetables` t LEFT JOIN `class_subjects` cs ON t.activity = cs.class_sub_id LEFT JOIN `subjects` s ON cs.subject_id = s.subject_id WHERE t.`class_id`=%d AND t.`stream_id`=%d AND t.`day`='%s' AND t.`%s`='%s' AND t.`%s`='%s'",
                                $class_id, $stream_id, mysqli_real_escape_string($con, $day), $startCol, mysqli_real_escape_string($con, $starttime), $endCol, mysqli_real_escape_string($con, $endtime)
                              );
                              $subject_query = @mysqli_query($con, $subject_sql);

                              $display = '-';
                              $activity_val = '';
                              if ($subject_query && mysqli_num_rows($subject_query) > 0) {
                                $subject_row = mysqli_fetch_assoc($subject_query);
                                if (!empty($subject_row['subject'])) {
                                  $display = $subject_row['subject'];
                                } else {
                                  $display = $subject_row['activity'] ?? '-';
                                }
                                $activity_val = $subject_row['activity'] ?? '';
                              }
                              echo htmlspecialchars($display, ENT_QUOTES);

                              // Check for active substitution for this class/day/time
                              // Calculate the date for this specific day of the week in the current week
                              $current_week_start = date('Y-m-d', strtotime('monday this week'));
                              
                              // Map short day names to offsets (MON=0, TUE=1, etc.)
                              $day_map = [
                                'MON' => 0, 'MONDAY' => 0,
                                'TUE' => 1, 'TUESDAY' => 1,
                                'WED' => 2, 'WEDNESDAY' => 2,
                                'THUR' => 3, 'THU' => 3, 'THURSDAY' => 3,
                                'FRI' => 4, 'FRIDAY' => 4
                              ];
                              
                              $day_upper = strtoupper(trim($day));
                              $day_offset = isset($day_map[$day_upper]) ? $day_map[$day_upper] : false;
                              
                              if ($day_offset !== false) {
                                $day_date = date('Y-m-d', strtotime($current_week_start . ' + ' . $day_offset . ' days'));
                              } else {
                                $day_date = date('Y-m-d'); // fallback
                              }
                              
                              // Prepare substitutions query using detected time column names
                              $sub_sql = sprintf("SELECT s.substitution_id, s.substitute_teacher_id, s.class_sub_id, s.date, t.fullname AS substitute_name FROM substitutions s LEFT JOIN teachers t ON s.substitute_teacher_id = t.teacher_id WHERE s.class_id = ? AND s.stream_id = ? AND s.date = ? AND s.%s = ? AND s.%s = ? AND s.status = 1 LIMIT 1", $startCol, $endCol);
                              $sub_q = mysqli_prepare($con, $sub_sql);
                              if ($sub_q) {
                                mysqli_stmt_bind_param($sub_q, 'iisss', $class_id, $stream_id, $day_date, $starttime, $endtime);
                                mysqli_stmt_execute($sub_q);
                                $sub_res = mysqli_stmt_get_result($sub_q);
                                
                                if ($sub_res && mysqli_num_rows($sub_res) > 0) {
                                  $subrow = mysqli_fetch_assoc($sub_res);
                                  $sub_name = $subrow['substitute_name'] ?? '';
                                  $sub_class_sub_id = (int)($subrow['class_sub_id'] ?? 0);
                                  $sub_subject = '';
                                  if ($sub_class_sub_id > 0) {
                                    $ssq = mysqli_query($con, "SELECT subject_id FROM class_subjects WHERE class_sub_id='" . $sub_class_sub_id . "' LIMIT 1");
                                    if ($ssq && $ssr = mysqli_fetch_assoc($ssq)) {
                                      $sid = (int)($ssr['subject_id'] ?? 0);
                                      if ($sid > 0) {
                                        $snameq = mysqli_query($con, "SELECT subject FROM subjects WHERE subject_id='" . $sid . "' LIMIT 1");
                                        if ($snameq && $sname = mysqli_fetch_assoc($snameq)) $sub_subject = $sname['subject'] ?? '';
                                      }
                                    }
                                  }
                                  // Fetch original teacher name for tooltip
                                  $orig_name = '';
                                  $orig_q = mysqli_prepare($con, "SELECT original_teacher_id FROM substitutions WHERE substitution_id = ? LIMIT 1");
                                  if ($orig_q) {
                                    mysqli_stmt_bind_param($orig_q, 'i', $subrow['substitution_id']);
                                    mysqli_stmt_execute($orig_q);
                                    $orig_res = mysqli_stmt_get_result($orig_q);
                                    if ($orig_res && $or = mysqli_fetch_assoc($orig_res)) {
                                      $orig_id_local = (int)($or['original_teacher_id'] ?? 0);
                                      if ($orig_id_local > 0) {
                                        $otq = mysqli_query($con, "SELECT fullname FROM teachers WHERE teacher_id='" . $orig_id_local . "' LIMIT 1");
                                        if ($otq && $orn = mysqli_fetch_assoc($otq)) $orig_name = $orn['fullname'] ?? '';
                                      }
                                    }
                                    if ($orig_q) mysqli_stmt_close($orig_q);
                                  }

                                  // More prominent badge (danger) with tooltip showing original teacher and link to details
                                  $tooltip = htmlspecialchars('Originally: ' . ($orig_name ?: 'N/A'), ENT_QUOTES);
                                  $badge_text = 'Sub: ' . htmlspecialchars($sub_name, ENT_QUOTES);
                                  if (!empty($sub_subject)) $badge_text .= ' — ' . htmlspecialchars($sub_subject, ENT_QUOTES);
                                  $detail_link = 'substitution_details.php?id=' . urlencode($subrow['substitution_id']);
                                  echo '<div style="margin-top:8px;">
                                    <a href="' . $detail_link . '" class="label label-danger substitution-badge" title="' . $tooltip . '">' . $badge_text . '</a>
                                  </div>';
                                }
                                if ($sub_q) mysqli_stmt_close($sub_q);
                              }
                              // show Find Substitute button to admins or the class teacher
                              if ($is_admin || ($is_class_teacher && $teacher_class_id === (int)$class_id)) {
                                $cell_date = $week_dates[$day] ?? date('Y-m-d');
                                ?>
                                <div style="margin-top:6px;">
                                  <button type="button" class="btn btn-xs btn-warning find-substitute-btn" 
                                    data-date="<?php echo htmlspecialchars($cell_date, ENT_QUOTES); ?>"
                                    data-starttime="<?php echo htmlspecialchars($starttime, ENT_QUOTES); ?>" 
                                    data-endtime="<?php echo htmlspecialchars($endtime, ENT_QUOTES); ?>" 
                                    data-class="<?php echo (int)$class_id; ?>" 
                                    data-stream="<?php echo (int)$stream_id; ?>" 
                                    data-activity="<?php echo htmlspecialchars($activity_val, ENT_QUOTES); ?>">
                                    Find Substitute
                                  </button>
                                </div>
                              <?php } ?>
                              
                              <?php
                              ?>
                            </td>
                          <?php endforeach; ?>
                        </tr>
                      <?php endforeach; ?>
                  </tbody>
                </table>
              </div>

              <?php if ($_SESSION['schoolsyslevel'] == 1): ?>
                <div class="text-center" style="margin-top: 20px;">
                  <a href="addtimetable?cl=<?php echo $class_id; ?>&&st=<?php echo $stream_id; ?>" class="btn btn-primary">
                    <i class="fa fa-plus"></i> Add/Edit Timetable
                  </a>
                </div>
              <?php endif; ?>

            </div>
          </section>
        </div>

      </div>


      </div>
      <!-- page end-->
    </section>
    <!--body wrapper end-->

    <!--footer section start-->

    <!--footer section end-->


    </div>
    <!-- main content end-->
  </section>

  <!-- Placed js at the end of the document so the pages load faster -->
  <script src="js/jquery-1.10.2.min.js"></script>
  <script src="js/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="js/jquery-migrate-1.2.1.min.js"></script>
  <script src="js/bootstrap.min.js"></script>
  <script src="js/modernizr.min.js"></script>
  <script src="js/jquery.nicescroll.js"></script>
  <script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
  <script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
  <script src="js/dynamic_table_init.js"></script>
  <!--common scripts for all pages-->
  <script src="js/scripts.js"></script>

  <!-- Find Substitute Modal -->
  <div id="findSubModal" class="modal" tabindex="-1" role="dialog" style="display:none;">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header" style="display:flex;align-items:center;justify-content:space-between;">
          <h5 class="modal-title">Find Substitute</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close" onclick="jQuery('#findSubModal').hide();">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <form id="findSubForm">
            <div class="form-group">
              <label>Date</label>
              <input type="date" name="date" class="form-control" required value="<?php echo date('Y-m-d'); ?>">
            </div>
            <div class="form-group">
              <label>Start Time</label>
              <input type="time" name="starttime" class="form-control" required>
            </div>
            <div class="form-group">
              <label>End Time</label>
              <input type="time" name="endtime" class="form-control" required>
            </div>
            <input type="hidden" name="class_id">
            <input type="hidden" name="stream_id">
            <input type="hidden" name="class_sub_id">
          </form>
          <div id="findSubResults" style="margin-top:12px;"></div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" onclick="jQuery('#findSubModal').hide();">Close</button>
        </div>
      </div>
    </div>
  </div>

  <script>
    jQuery(function($){
      $(document).on('click', '.find-substitute-btn', function(e){
        e.preventDefault();
        var btn = $(this);
        var date = btn.data('date') || new Date().toISOString().slice(0,10);
        var start = btn.data('starttime');
        var end = btn.data('endtime');
        var cls = btn.data('class');
        var st = btn.data('stream');
        var act = btn.data('activity');
        var modal = $('#findSubModal');
        modal.find('input[name="date"]').val(date);
        modal.find('input[name="starttime"]').val(start);
        modal.find('input[name="endtime"]').val(end);
        modal.find('input[name="class_id"]').val(cls);
        modal.find('input[name="stream_id"]').val(st);
        modal.find('input[name="class_sub_id"]').val($.isNumeric(act) ? act : '');
        $('#findSubResults').html('');
        modal.show();
        // trigger search
        modal.find('input').trigger('change');
      });

      $(document).on('change', '#findSubForm input, #findSubForm select', function(){
        var form = $('#findSubForm');
        var data = form.serialize();
        $('#findSubResults').html('Searching...');
        $.ajax({
          url: 'find_substitute.php',
          method: 'POST',
          data: data,
          dataType: 'json',
          success: function(resp) {
            if (resp.error) { $('#findSubResults').html('<div class="alert alert-danger">'+resp.error+'</div>'); return; }
            var html = '';
            if (resp.available && resp.available.length) {
              html += '<ul class="list-group">';
              resp.available.forEach(function(t){
                html += '<li class="list-group-item">' +
                  '<strong>' + $('<div>').text(t.fullname).html() + '</strong> ' +
                  ' (' + $('<div>').text(t.designation).html() + ') ' +
                  '<button class="btn btn-xs btn-success pull-right assign-sub-btn" data-teacher="'+t.teacher_id+'">Assign</button>' +
                  '</li>';
              });
              html += '</ul>';
            } else {
              html = '<div class="alert alert-info">No available teachers found.</div>';
            }
            $('#findSubResults').html(html);
          },
          error: function(xhr, status, err) {
            var body = xhr.responseText || '';
            $('#findSubResults').html('<div class="alert alert-danger">Request failed: ' + xhr.status + ' ' + xhr.statusText + '<br><pre style="white-space:pre-wrap;">' + $('<div>').text(body).html() + '</pre></div>');
          }
        });
      });

      $(document).on('click', '.assign-sub-btn', function(){
        var teacher_id = $(this).data('teacher');
        var form = $('#findSubForm');
        var data = form.serializeArray();
        data.push({name: 'substitute_teacher_id', value: teacher_id});
        data.push({name: 'original_teacher_id', value: ''});
        $.ajax({
          url: 'assign_substitute.php',
          method: 'POST',
          data: $.param(data),
          dataType: 'json',
          success: function(resp){
            if (resp.error) { $('#findSubResults').html('<div class="alert alert-danger">Error: '+resp.error+'</div>'); return; }
            var okHtml = '<div class="alert alert-success">Substitution recorded successfully. Reference ID: <strong>'+ (resp.substitution_id || '') +'</strong></div>';
            $('#findSubResults').html(okHtml);
            // auto-close modal and refresh page after short delay
            setTimeout(function(){ jQuery('#findSubModal').hide(); }, 1800);
            setTimeout(function(){ location.reload(); }, 2000);
          },
          error: function(xhr){
            var body = xhr.responseText || '';
            alert('Request failed: ' + xhr.status + ' ' + xhr.statusText + '\n' + body);
          }
        });
      });
    });
  </script>

</body>

</html>